/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.GraknTx;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.kb.internal.GraknTxAbstract;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.RelationshipTypeImpl;
import ai.grakn.kb.internal.concept.RuleImpl;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ValidateGlobalRules {
    private ValidateGlobalRules() {
        throw new UnsupportedOperationException();
    }

    static Set<String> validatePlaysAndRelatesStructure(Casting casting) {
        HashSet<String> errors = new HashSet<String>();
        Thing thing = casting.getRolePlayer();
        Role role = casting.getRole();
        Relationship relation = casting.getRelationship();
        ValidateGlobalRules.roleNotAllowedToBePlayed(role, thing).ifPresent(errors::add);
        ValidateGlobalRules.roleNotLinkedToRelationShip(role, relation.type(), relation).ifPresent(errors::add);
        return errors;
    }

    private static Optional<String> roleNotLinkedToRelationShip(Role role, RelationshipType relationshipType, Relationship relationship) {
        boolean notFound = role.relationshipTypes().noneMatch(innerRelationType -> innerRelationType.getLabel().equals(relationshipType.getLabel()));
        if (notFound) {
            return Optional.of(ErrorMessage.VALIDATION_RELATION_CASTING_LOOP_FAIL.getMessage(new Object[]{relationship.getId(), role.getLabel(), relationshipType.getLabel()}));
        }
        return Optional.empty();
    }

    private static Optional<String> roleNotAllowedToBePlayed(Role role, Thing thing) {
        boolean satisfiesPlays = false;
        for (TypeImpl currentConcept = (TypeImpl)thing.type(); currentConcept != null; currentConcept = (TypeImpl)currentConcept.sup()) {
            Map<Role, Boolean> plays = currentConcept.directPlays();
            for (Map.Entry<Role, Boolean> playsEntry : plays.entrySet()) {
                Role rolePlayed = playsEntry.getKey();
                Boolean required = playsEntry.getValue();
                if (!rolePlayed.getLabel().equals(role.getLabel())) continue;
                satisfiesPlays = true;
                if (!required.booleanValue() || CommonUtil.containsOnly((Stream)thing.relationships(new Role[]{role}), (long)1L)) continue;
                return Optional.of(ErrorMessage.VALIDATION_REQUIRED_RELATION.getMessage(new Object[]{thing.getId(), thing.type().getLabel(), role.getLabel(), thing.relationships(new Role[]{role}).count()}));
            }
        }
        if (satisfiesPlays) {
            return Optional.empty();
        }
        return Optional.of(ErrorMessage.VALIDATION_CASTING.getMessage(new Object[]{thing.type().getLabel(), thing.getId(), role.getLabel()}));
    }

    static Optional<String> validateHasSingleIncomingRelatesEdge(Role role) {
        if (!role.relationshipTypes().findAny().isPresent()) {
            return Optional.of(ErrorMessage.VALIDATION_ROLE_TYPE_MISSING_RELATION_TYPE.getMessage(new Object[]{role.getLabel()}));
        }
        return Optional.empty();
    }

    static Optional<String> validateHasMinimumRoles(RelationshipType relationshipType) {
        if (relationshipType.isAbstract().booleanValue() || relationshipType.relates().iterator().hasNext()) {
            return Optional.empty();
        }
        return Optional.of(ErrorMessage.VALIDATION_RELATION_TYPE.getMessage(new Object[]{relationshipType.getLabel()}));
    }

    static Set<String> validateRelationTypesToRolesSchema(RelationshipType relationshipType) {
        RelationshipTypeImpl superRelationType = (RelationshipTypeImpl)relationshipType.sup();
        if (Schema.MetaSchema.isMetaLabel((Label)superRelationType.getLabel()) || superRelationType.isAbstract().booleanValue()) {
            return Collections.emptySet();
        }
        HashSet<String> errorMessages = new HashSet<String>();
        Collection superRelates = superRelationType.relates().collect(Collectors.toSet());
        Collection relates = relationshipType.relates().collect(Collectors.toSet());
        Set relatesLabels = relates.stream().map(SchemaConcept::getLabel).collect(Collectors.toSet());
        if (!superRelationType.isAbstract().booleanValue()) {
            HashSet allSuperRolesPlayed = new HashSet();
            superRelationType.superSet().forEach(rel -> rel.relates().forEach(roleType -> allSuperRolesPlayed.add(roleType.getLabel())));
            for (Role relate : relates) {
                boolean validRoleTypeFound = SchemaConceptImpl.from((SchemaConcept)relate).superSet().anyMatch(superRole -> allSuperRolesPlayed.contains(superRole.getLabel()));
                if (validRoleTypeFound) continue;
                errorMessages.add(ErrorMessage.VALIDATION_RELATION_TYPES_ROLES_SCHEMA.getMessage(new Object[]{relate.getLabel(), relationshipType.getLabel(), "super", "super", superRelationType.getLabel()}));
            }
        }
        for (Role superRelate : superRelates) {
            boolean subRoleNotFoundInRelates = superRelate.subs().noneMatch(sub -> relatesLabels.contains(sub.getLabel()));
            if (!subRoleNotFoundInRelates) continue;
            errorMessages.add(ErrorMessage.VALIDATION_RELATION_TYPES_ROLES_SCHEMA.getMessage(new Object[]{superRelate.getLabel(), superRelationType.getLabel(), "sub", "sub", relationshipType.getLabel()}));
        }
        return errorMessages;
    }

    static Optional<String> validateInstancePlaysAllRequiredRoles(Thing thing) {
        for (TypeImpl currentConcept = (TypeImpl)thing.type(); currentConcept != null; currentConcept = (TypeImpl)currentConcept.sup()) {
            Map<Role, Boolean> plays = currentConcept.directPlays();
            for (Map.Entry<Role, Boolean> playsEntry : plays.entrySet()) {
                if (!playsEntry.getValue().booleanValue()) continue;
                Role role = playsEntry.getKey();
                Stream relations = thing.relationships(new Role[]{role});
                if (CommonUtil.containsOnly((Stream)relations, (long)1L)) continue;
                Label resourceTypeLabel = Schema.ImplicitType.explicitLabel((Label)role.getLabel());
                return Optional.of(ErrorMessage.VALIDATION_NOT_EXACTLY_ONE_KEY.getMessage(new Object[]{thing.getId(), resourceTypeLabel}));
            }
        }
        return Optional.empty();
    }

    static Optional<String> validateRelationIsUnique(GraknTxAbstract<?> graph, RelationshipReified relationReified) {
        Iterator<AttributeType> keys = ((RelationshipType)relationReified.type()).keys().iterator();
        if (keys.hasNext()) {
            return ValidateGlobalRules.validateKeyControlledRelation(graph, relationReified, keys);
        }
        return ValidateGlobalRules.validateNonKeyControlledRelation(graph, relationReified);
    }

    private static Optional<String> validateKeyControlledRelation(GraknTxAbstract<?> graph, RelationshipReified relationReified, Iterator<AttributeType> keys) {
        TreeMap<String, String> resources = new TreeMap<String, String>();
        while (keys.hasNext()) {
            Optional<Attribute<?>> foundResource = relationReified.attributes(keys.next()).findAny();
            foundResource.ifPresent(resource -> resources.put(resource.type().getId().getValue(), resource.getId().getValue()));
        }
        String hash = RelationshipReified.generateNewHash((RelationshipType)relationReified.type(), resources);
        return ValidateGlobalRules.setRelationUnique(graph, relationReified, hash);
    }

    private static Optional<String> validateNonKeyControlledRelation(GraknTxAbstract<?> graph, RelationshipReified relationReified) {
        String hash = RelationshipReified.generateNewHash((RelationshipType)relationReified.type(), relationReified.allRolePlayers());
        return ValidateGlobalRules.setRelationUnique(graph, relationReified, hash);
    }

    private static Optional<String> setRelationUnique(GraknTxAbstract<?> graph, RelationshipReified relationReified, String hash) {
        Optional foundRelation = graph.getConcept(Schema.VertexProperty.INDEX, hash);
        if (!foundRelation.isPresent()) {
            relationReified.setHash(hash);
        } else if (((RelationshipImpl)foundRelation.get()).reified().isPresent() && !((RelationshipImpl)foundRelation.get()).reified().get().equals(relationReified)) {
            return Optional.of(ErrorMessage.VALIDATION_RELATION_DUPLICATE.getMessage(new Object[]{relationReified}));
        }
        return Optional.empty();
    }

    static Set<String> validateRuleIsValidHornClause(GraknTx graph, Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        if (rule.getWhen().admin().isDisjunction()) {
            errors.add(ErrorMessage.VALIDATION_RULE_DISJUNCTION_IN_BODY.getMessage(new Object[]{rule.getLabel()}));
        }
        errors.addAll(ValidateGlobalRules.checkRuleHeadInvalid(graph, rule, rule.getThen()));
        return errors;
    }

    static Set<String> validateRuleOntologically(GraknTx graph, Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        ReasonerQuery combined = ((Conjunction)rule.getWhen().and(rule.getThen()).admin().getDisjunctiveNormalForm().getPatterns().iterator().next()).toReasonerQuery(graph);
        errors.addAll(combined.validateOntologically());
        return errors;
    }

    private static Set<String> checkRuleHeadInvalid(GraknTx graph, Rule rule, Pattern head) {
        HashSet<String> errors = new HashSet<String>();
        Set patterns = head.admin().getDisjunctiveNormalForm().getPatterns();
        if (patterns.size() != 1) {
            errors.add(ErrorMessage.VALIDATION_RULE_DISJUNCTION_IN_HEAD.getMessage(new Object[]{rule.getLabel()}));
        } else {
            ReasonerQuery headQuery = ((Conjunction)patterns.iterator().next()).toReasonerQuery(graph);
            Set allowed = headQuery.getAtoms().stream().filter(Atomic::isAllowedToFormRuleHead).collect(Collectors.toSet());
            if (allowed.size() > 1) {
                errors.add(ErrorMessage.VALIDATION_RULE_HEAD_NON_ATOMIC.getMessage(new Object[]{rule.getLabel()}));
            } else if (allowed.isEmpty()) {
                errors.add(ErrorMessage.VALIDATION_RULE_ILLEGAL_ATOMIC_IN_HEAD.getMessage(new Object[]{rule.getLabel()}));
            }
        }
        return errors;
    }

    static Set<String> validateRuleSchemaConceptExist(GraknTx graph, Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        errors.addAll(ValidateGlobalRules.checkRuleSideInvalid(graph, rule, Schema.VertexProperty.RULE_WHEN, rule.getWhen()));
        errors.addAll(ValidateGlobalRules.checkRuleSideInvalid(graph, rule, Schema.VertexProperty.RULE_THEN, rule.getThen()));
        return errors;
    }

    private static Set<String> checkRuleSideInvalid(GraknTx graph, Rule rule, Schema.VertexProperty side, Pattern pattern) {
        HashSet<String> errors = new HashSet<String>();
        pattern.admin().varPatterns().stream().flatMap(v -> v.innerVarPatterns().stream()).flatMap(v -> v.getTypeLabels().stream()).forEach(typeLabel -> {
            SchemaConcept schemaConcept = graph.getSchemaConcept(typeLabel);
            if (schemaConcept == null) {
                errors.add(ErrorMessage.VALIDATION_RULE_MISSING_ELEMENTS.getMessage(new Object[]{side, rule.getLabel(), typeLabel}));
            } else if (Schema.VertexProperty.RULE_WHEN.equals((Object)side)) {
                if (schemaConcept.isType()) {
                    RuleImpl.from(rule).addHypothesis(schemaConcept.asType());
                }
            } else if (Schema.VertexProperty.RULE_THEN.equals((Object)side)) {
                if (schemaConcept.isType()) {
                    RuleImpl.from(rule).addConclusion(schemaConcept.asType());
                }
            } else {
                throw GraknTxOperationException.invalidPropertyUse((Concept)rule, (Schema.VertexProperty)side);
            }
        });
        return errors;
    }
}

