/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.GraknTxAbstract;
import ai.grakn.kb.internal.ValidateGlobalRules;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.structure.Casting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class Validator {
    private final GraknTxAbstract<?> graknGraph;
    private final List<String> errorsFound = new ArrayList<String>();

    public Validator(GraknTxAbstract graknGraph) {
        this.graknGraph = graknGraph;
    }

    public List<String> getErrorsFound() {
        return this.errorsFound;
    }

    public boolean validate() {
        this.graknGraph.txCache().getModifiedEntities().forEach(this::validateThing);
        this.graknGraph.txCache().getModifiedRoles().forEach(this::validateRole);
        this.graknGraph.txCache().getModifiedCastings().forEach(this::validateCasting);
        this.graknGraph.txCache().getModifiedRelationshipTypes().forEach(this::validateRelationType);
        this.graknGraph.txCache().getModifiedRelationships().forEach(relation -> this.validateRelation(this.graknGraph, (Relationship)relation));
        this.graknGraph.txCache().getModifiedRules().forEach(rule -> this.validateRule(this.graknGraph, (Rule)rule));
        this.graknGraph.txCache().getModifiedAttributes().forEach(this::validateThing);
        return this.errorsFound.size() == 0;
    }

    private void validateRule(GraknTxAbstract<?> graph, Rule rule) {
        Set<String> labelErrors = ValidateGlobalRules.validateRuleSchemaConceptExist(graph, rule);
        this.errorsFound.addAll(labelErrors);
        this.errorsFound.addAll(ValidateGlobalRules.validateRuleIsValidHornClause(graph, rule));
        if (labelErrors.isEmpty()) {
            this.errorsFound.addAll(ValidateGlobalRules.validateRuleOntologically(graph, rule));
        }
    }

    private void validateRelation(GraknTxAbstract<?> graph, Relationship relationship) {
        this.validateThing((Thing)relationship);
        Optional<RelationshipReified> relationReified = ((RelationshipImpl)relationship).reified();
        relationReified.ifPresent(relationReified1 -> ValidateGlobalRules.validateRelationIsUnique(graph, relationReified1).ifPresent(this.errorsFound::add));
    }

    private void validateCasting(Casting casting) {
        this.errorsFound.addAll(ValidateGlobalRules.validatePlaysAndRelatesStructure(casting));
    }

    private void validateRole(Role role) {
        ValidateGlobalRules.validateHasSingleIncomingRelatesEdge(role).ifPresent(this.errorsFound::add);
    }

    private void validateRelationType(RelationshipType relationshipType) {
        ValidateGlobalRules.validateHasMinimumRoles(relationshipType).ifPresent(this.errorsFound::add);
        this.errorsFound.addAll(ValidateGlobalRules.validateRelationTypesToRolesSchema(relationshipType));
    }

    private void validateThing(Thing thing) {
        ValidateGlobalRules.validateInstancePlaysAllRequiredRoles(thing).ifPresent(this.errorsFound::add);
    }
}

