/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.cache;

import ai.grakn.kb.internal.cache.Cacheable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Cache<V> {
    private final Supplier<V> databaseReader;
    private final Cacheable<V> cacheable;
    private final ThreadLocal<V> valueTx = new ThreadLocal();
    private Optional<V> valueGlobal = Optional.empty();

    public Cache(Cacheable<V> cacheable, Supplier<V> databaseReader) {
        this.cacheable = cacheable;
        this.databaseReader = databaseReader;
    }

    @Nullable
    public V get() {
        V value = this.valueTx.get();
        if (value != null) {
            return value;
        }
        if (this.valueGlobal.isPresent()) {
            value = this.cacheable.copy(this.valueGlobal.get());
        }
        if (value == null) {
            value = this.databaseReader.get();
        }
        if (value == null) {
            return null;
        }
        this.valueTx.set(value);
        return this.valueTx.get();
    }

    public void clear() {
        this.valueTx.remove();
    }

    public void set(@Nullable V value) {
        this.valueTx.set(value);
    }

    private boolean isPresent() {
        return this.valueTx.get() != null || this.valueGlobal.isPresent();
    }

    public void ifPresent(Consumer<V> modifier) {
        if (this.isPresent()) {
            modifier.accept(this.get());
        }
    }

    public void flush() {
        if (this.isPresent()) {
            V newValue = this.get();
            if (!this.valueGlobal.isPresent() || !this.valueGlobal.get().equals(newValue)) {
                this.valueGlobal = Optional.of(this.get());
            }
        }
    }
}

