/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.cache;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.kb.internal.cache.TxCache;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GlobalCache {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final int DEFAULT_CACHE_TIMEOUT_MS = 600000;
    private final Cache<Label, SchemaConcept> cachedTypes;
    private final Map<Label, LabelId> cachedLabels = new ConcurrentHashMap<Label, LabelId>();

    public GlobalCache(Properties properties) {
        int cacheTimeout = Integer.parseInt(properties.getProperty("knowledge-base.schema-cache-timeout-ms", String.valueOf(600000)));
        this.cachedTypes = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess((long)cacheTimeout, TimeUnit.MILLISECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateSchemaTxCache(TxCache txCache) {
        try {
            this.lock.writeLock().lock();
            Map<Label, SchemaConcept> cachedSchemaSnapshot = this.getCachedTypes();
            Map<Label, LabelId> cachedLabelsSnapshot = this.getCachedLabels();
            for (SchemaConcept type : cachedSchemaSnapshot.values()) {
                txCache.cacheConcept((Concept)type);
            }
            cachedLabelsSnapshot.forEach(txCache::cacheLabel);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void cacheType(Label label, SchemaConcept type) {
        this.cachedTypes.put((Object)label, (Object)type);
    }

    public void cacheLabel(Label label, LabelId id) {
        this.cachedLabels.put(label, id);
    }

    void readTxCache(TxCache txCache) {
        if (!this.cachedLabels.equals(txCache.getLabelCache())) {
            try {
                this.lock.readLock().lock();
                this.cachedLabels.clear();
                this.cachedTypes.invalidateAll();
                this.cachedLabels.putAll(txCache.getLabelCache());
                this.cachedTypes.putAll(txCache.getSchemaConceptCache());
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        txCache.getSchemaConceptCache().values().forEach(schemaConcept -> SchemaConceptImpl.from(schemaConcept).txCacheFlush());
    }

    private Map<Label, LabelId> getCachedLabels() {
        return ImmutableMap.copyOf(this.cachedLabels);
    }

    public Map<Label, SchemaConcept> getCachedTypes() {
        return ImmutableMap.copyOf((Map)this.cachedTypes.asMap());
    }
}

