/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.cache;

import ai.grakn.GraknTxType;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.kb.internal.cache.ContainsTxCache;
import ai.grakn.kb.internal.cache.GlobalCache;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.structure.Casting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TxCache {
    private final GlobalCache globalCache;
    private final Map<ConceptId, Concept> conceptCache = new HashMap<ConceptId, Concept>();
    private final Map<Label, SchemaConcept> schemaConceptCache = new HashMap<Label, SchemaConcept>();
    private final Map<Label, LabelId> labelCache = new HashMap<Label, LabelId>();
    private final Set<Entity> modifiedEntities = new HashSet<Entity>();
    private final Set<Role> modifiedRoles = new HashSet<Role>();
    private final Set<Casting> modifiedCastings = new HashSet<Casting>();
    private final Set<RelationshipType> modifiedRelationshipTypes = new HashSet<RelationshipType>();
    private final Set<Relationship> modifiedRelationships = new HashSet<Relationship>();
    private final Set<Rule> modifiedRules = new HashSet<Rule>();
    private final Set<Attribute> modifiedAttributes = new HashSet<Attribute>();
    private final Map<String, Relationship> relationIndexCache = new HashMap<String, Relationship>();
    private final Map<ConceptId, Long> shardingCount = new HashMap<ConceptId, Long>();
    private Map<String, ConceptId> newAttributes = new HashMap<String, ConceptId>();
    private boolean isTxOpen = false;
    private GraknTxType txType;
    private String closedReason = null;

    public TxCache(GlobalCache globalCache) {
        this.globalCache = globalCache;
    }

    public void writeToGraphCache(boolean isSafe) {
        if (isSafe) {
            this.globalCache.readTxCache(this);
        }
    }

    public boolean schemaNotCached() {
        return this.labelCache.isEmpty();
    }

    public void refreshSchemaCache() {
        this.globalCache.populateSchemaTxCache(this);
    }

    public void trackForValidation(Concept concept) {
        if (concept.isEntity()) {
            this.modifiedEntities.add(concept.asEntity());
        } else if (concept.isRole()) {
            this.modifiedRoles.add(concept.asRole());
        } else if (concept.isRelationshipType()) {
            this.modifiedRelationshipTypes.add(concept.asRelationshipType());
        } else if (concept.isRelationship()) {
            Relationship relationship = concept.asRelationship();
            this.modifiedRelationships.add(relationship);
            this.relationIndexCache.put(RelationshipReified.generateNewHash(relationship.type(), relationship.allRolePlayers()), relationship);
        } else if (concept.isRule()) {
            this.modifiedRules.add(concept.asRule());
        } else if (concept.isAttribute()) {
            this.modifiedAttributes.add(concept.asAttribute());
        }
    }

    public void trackForValidation(Casting casting) {
        this.modifiedCastings.add(casting);
    }

    public void removeFromValidation(Type type) {
        if (type.isRelationshipType()) {
            this.modifiedRelationshipTypes.add(type.asRelationshipType());
        }
    }

    public Map<String, Relationship> getRelationIndexCache() {
        return this.relationIndexCache;
    }

    public Map<ConceptId, Long> getShardingCount() {
        return this.shardingCount;
    }

    Map<Label, SchemaConcept> getSchemaConceptCache() {
        return this.schemaConceptCache;
    }

    Map<Label, LabelId> getLabelCache() {
        return this.labelCache;
    }

    Map<ConceptId, Concept> getConceptCache() {
        return this.conceptCache;
    }

    public void remove(Concept concept) {
        this.modifiedEntities.remove(concept);
        this.modifiedRoles.remove(concept);
        this.modifiedRelationshipTypes.remove(concept);
        this.modifiedRelationships.remove(concept);
        this.modifiedRules.remove(concept);
        this.modifiedAttributes.remove(concept);
        if (concept.isAttribute()) {
            this.newAttributes.remove(AttributeImpl.from(concept.asAttribute()).getIndex());
        }
        this.conceptCache.remove(concept.getId());
        if (concept.isSchemaConcept()) {
            Label label = concept.asSchemaConcept().getLabel();
            this.schemaConceptCache.remove(label);
            this.labelCache.remove(label);
        }
    }

    public Relationship getCachedRelation(String index) {
        return this.relationIndexCache.get(index);
    }

    public void cacheConcept(Concept concept) {
        this.conceptCache.put(concept.getId(), concept);
        if (concept.isSchemaConcept()) {
            SchemaConcept schemaConcept = concept.asSchemaConcept();
            this.schemaConceptCache.put(schemaConcept.getLabel(), schemaConcept);
            this.labelCache.put(schemaConcept.getLabel(), schemaConcept.getLabelId());
        }
    }

    void cacheLabel(Label label, LabelId id) {
        this.labelCache.put(label, id);
    }

    public boolean isConceptCached(ConceptId id) {
        return this.conceptCache.containsKey(id);
    }

    public boolean isTypeCached(Label label) {
        return this.schemaConceptCache.containsKey(label);
    }

    public boolean isLabelCached(Label label) {
        return this.labelCache.containsKey(label);
    }

    public <X extends Concept> X getCachedConcept(ConceptId id) {
        return (X)this.conceptCache.get(id);
    }

    public <X extends SchemaConcept> X getCachedSchemaConcept(Label label) {
        return (X)this.schemaConceptCache.get(label);
    }

    public LabelId convertLabelToId(Label label) {
        return this.labelCache.get(label);
    }

    public void addedInstance(ConceptId conceptId) {
        this.shardingCount.compute(conceptId, (key, value) -> value == null ? 1L : value + 1L);
        this.cleanupShardingCount(conceptId);
    }

    public void removedInstance(ConceptId conceptId) {
        this.shardingCount.compute(conceptId, (key, value) -> value == null ? -1L : value - 1L);
        this.cleanupShardingCount(conceptId);
    }

    private void cleanupShardingCount(ConceptId conceptId) {
        if (this.shardingCount.get(conceptId) == 0L) {
            this.shardingCount.remove(conceptId);
        }
    }

    public void addNewAttribute(String index, ConceptId conceptId) {
        this.newAttributes.put(index, conceptId);
    }

    public Map<String, ConceptId> getNewAttributes() {
        return this.newAttributes;
    }

    public Set<Entity> getModifiedEntities() {
        return this.modifiedEntities;
    }

    public Set<Role> getModifiedRoles() {
        return this.modifiedRoles;
    }

    public Set<RelationshipType> getModifiedRelationshipTypes() {
        return this.modifiedRelationshipTypes;
    }

    public Set<Relationship> getModifiedRelationships() {
        return this.modifiedRelationships;
    }

    public Set<Rule> getModifiedRules() {
        return this.modifiedRules;
    }

    public Set<Attribute> getModifiedAttributes() {
        return this.modifiedAttributes;
    }

    public Set<Casting> getModifiedCastings() {
        return this.modifiedCastings;
    }

    public void closeTx(String closedReason) {
        this.isTxOpen = false;
        this.closedReason = closedReason;
        this.conceptCache.values().forEach(concept -> ContainsTxCache.from(concept).txCacheClear());
        this.modifiedEntities.clear();
        this.modifiedRoles.clear();
        this.modifiedRelationshipTypes.clear();
        this.modifiedRelationships.clear();
        this.modifiedRules.clear();
        this.modifiedAttributes.clear();
        this.modifiedCastings.clear();
        this.newAttributes.clear();
        this.relationIndexCache.clear();
        this.shardingCount.clear();
        this.conceptCache.clear();
        this.schemaConceptCache.clear();
        this.labelCache.clear();
    }

    public void openTx(GraknTxType txType) {
        this.isTxOpen = true;
        this.txType = txType;
        this.closedReason = null;
    }

    public boolean isTxOpen() {
        return this.isTxOpen;
    }

    public GraknTxType txType() {
        return this.txType;
    }

    public String getClosedReason() {
        return this.closedReason;
    }
}

