/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.computer;

import ai.grakn.GraknComputer;
import ai.grakn.concept.LabelId;
import ai.grakn.kb.internal.computer.GraknSparkComputer;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class GraknComputerImpl
implements GraknComputer {
    private final Graph graph;
    private final Class<? extends GraphComputer> graphComputerClass;
    private GraphComputer graphComputer = null;

    public GraknComputerImpl(Graph graph) {
        this.graph = graph;
        this.graphComputerClass = graph instanceof TinkerGraph ? TinkerGraphComputer.class : GraknSparkComputer.class;
    }

    public ComputerResult compute(@Nullable VertexProgram program, @Nullable MapReduce mapReduce, @Nullable Set<LabelId> types, Boolean includesRolePlayerEdges) {
        try {
            if (program != null) {
                this.graphComputer = this.getGraphComputer().program(program);
            }
            if (mapReduce != null) {
                this.graphComputer = this.graphComputer.mapReduce(mapReduce);
            }
            this.applyFilters(types, includesRolePlayerEdges);
            return (ComputerResult)this.graphComputer.submit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw this.asRuntimeException(e.getCause());
        }
    }

    public ComputerResult compute(@Nullable VertexProgram program, @Nullable MapReduce mapReduce, @Nullable Set<LabelId> types) {
        return this.compute(program, mapReduce, types, true);
    }

    public void killJobs() {
        if (this.graphComputer != null && this.graphComputerClass.equals(GraknSparkComputer.class)) {
            ((GraknSparkComputer)this.graphComputer).cancelJobs();
        }
    }

    private RuntimeException asRuntimeException(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new RuntimeException(cause);
    }

    protected Class<? extends GraphComputer> getGraphComputerClass(String graphComputerType) {
        try {
            return Class.forName(graphComputerType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(ErrorMessage.INVALID_COMPUTER.getMessage(new Object[]{graphComputerType}));
        }
    }

    protected GraphComputer getGraphComputer() {
        return this.graph.compute(this.graphComputerClass);
    }

    private void applyFilters(Set<LabelId> types, boolean includesRolePlayerEdge) {
        if (types == null || types.isEmpty()) {
            return;
        }
        Set labelIds = types.stream().map(LabelId::getValue).collect(Collectors.toSet());
        GraphTraversal vertexFilter = __.has((String)Schema.VertexProperty.THING_TYPE_LABEL_ID.name(), (P)P.within(labelIds));
        GraphTraversal edgeFilter = includesRolePlayerEdge ? __.union((Traversal[])new Traversal[]{__.bothE((String[])new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}), __.bothE((String[])new String[]{Schema.EdgeLabel.ATTRIBUTE.getLabel()}).has(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID.name(), P.within(labelIds))}) : __.union((Traversal[])new Traversal[]{__.bothE((String[])new String[]{Schema.EdgeLabel.ATTRIBUTE.getLabel()}).has(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID.name(), P.within(labelIds))});
        this.graphComputer.vertices((Traversal)vertexFilter).edges((Traversal)edgeFilter);
    }
}

