/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.concept.ThingImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class AttributeImpl<D>
extends ThingImpl<Attribute<D>, AttributeType<D>>
implements Attribute<D> {
    private AttributeImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    private AttributeImpl(VertexElement vertexElement, AttributeType<D> type, Object value) {
        super(vertexElement, type);
        this.setValue(value);
    }

    public static <D> AttributeImpl<D> get(VertexElement vertexElement) {
        return new AttributeImpl<D>(vertexElement);
    }

    public static <D> AttributeImpl<D> create(VertexElement vertexElement, AttributeType<D> type, Object value) {
        AttributeImpl<D> attribute = new AttributeImpl<D>(vertexElement, type, value);
        String index = Schema.generateAttributeIndex((Label)type.getLabel(), (String)value.toString());
        vertexElement.tx().txCache().addNewAttribute(index, attribute.getId());
        return attribute;
    }

    public AttributeType.DataType<D> dataType() {
        return ((AttributeType)this.type()).getDataType();
    }

    public Stream<Thing> ownerInstances() {
        Stream implicitOwners = this.getShortcutNeighbours();
        Stream edgeOwners = this.neighbours(Direction.IN, Schema.EdgeLabel.ATTRIBUTE);
        return Stream.concat(implicitOwners, edgeOwners);
    }

    public Thing owner() {
        Iterator owners = this.ownerInstances().iterator();
        if (owners.hasNext()) {
            return (Thing)owners.next();
        }
        return null;
    }

    private void setValue(Object value) {
        Schema.VertexProperty property = this.dataType().getVertexProperty();
        this.vertex().propertyImmutable(property, value, this.vertex().property(property));
    }

    public D getValue() {
        return (D)this.dataType().getValue(this.vertex().property(this.dataType().getVertexProperty()));
    }

    @Override
    public String innerToString() {
        return super.innerToString() + "- Value [" + this.getValue() + "] ";
    }

    public static AttributeImpl from(Attribute attribute) {
        return (AttributeImpl)attribute;
    }
}

