/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class AttributeTypeImpl<D>
extends TypeImpl<AttributeType<D>, Attribute<D>>
implements AttributeType<D> {
    private AttributeTypeImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    private AttributeTypeImpl(VertexElement vertexElement, AttributeType<D> type, AttributeType.DataType<D> dataType) {
        super(vertexElement, type);
        this.vertex().propertyImmutable(Schema.VertexProperty.DATA_TYPE, dataType, this.getDataType(), AttributeType.DataType::getName);
    }

    public static <D> AttributeTypeImpl<D> get(VertexElement vertexElement) {
        return new AttributeTypeImpl<D>(vertexElement);
    }

    public static <D> AttributeTypeImpl<D> create(VertexElement vertexElement, AttributeType<D> type, AttributeType.DataType<D> dataType) {
        return new AttributeTypeImpl<D>(vertexElement, type, dataType);
    }

    @Override
    public AttributeType<D> sup(AttributeType<D> superType) {
        ((AttributeTypeImpl)superType).superSet().forEach(st -> this.checkInstancesMatchRegex(st.getRegex()));
        return super.sup(superType);
    }

    public AttributeType<D> setRegex(String regex) {
        if (this.getDataType() == null || !this.getDataType().equals((Object)AttributeType.DataType.STRING)) {
            throw GraknTxOperationException.cannotSetRegex((AttributeType)this);
        }
        this.checkInstancesMatchRegex(regex);
        return (AttributeType)this.property(Schema.VertexProperty.REGEX, regex);
    }

    private void checkInstancesMatchRegex(@Nullable String regex) {
        if (regex != null) {
            Pattern pattern = Pattern.compile(regex);
            this.instances().forEach(resource -> {
                String value = (String)resource.getValue();
                Matcher matcher = pattern.matcher(value);
                if (!matcher.matches()) {
                    throw GraknTxOperationException.regexFailure((AttributeType)this, (String)value, (String)regex);
                }
            });
        }
    }

    public Attribute<D> putAttribute(D value) {
        Objects.requireNonNull(value);
        BiFunction<VertexElement, AttributeType, Attribute> instanceBuilder = (vertex, type) -> {
            if (this.getDataType().equals((Object)AttributeType.DataType.STRING)) {
                this.checkConformsToRegexes(value);
            }
            Object persistenceValue = this.castValue(value);
            AttributeImpl resource = this.vertex().tx().factory().buildResource((VertexElement)vertex, type, persistenceValue);
            resource.vertex().propertyUnique(Schema.VertexProperty.INDEX, Schema.generateAttributeIndex((Label)this.getLabel(), (String)value.toString()));
            return resource;
        };
        return this.putInstance(Schema.BaseType.ATTRIBUTE, () -> this.getAttribute(value), instanceBuilder);
    }

    private Object castValue(D value) {
        AttributeType.DataType<D> dataType = this.getDataType();
        try {
            if (dataType.equals((Object)AttributeType.DataType.DOUBLE)) {
                return ((Number)value).doubleValue();
            }
            if (dataType.equals((Object)AttributeType.DataType.LONG)) {
                if (value instanceof Double) {
                    throw new ClassCastException();
                }
                return ((Number)value).longValue();
            }
            return dataType.getPersistenceValue(value);
        }
        catch (ClassCastException e) {
            throw GraknTxOperationException.invalidResourceValue(value, dataType);
        }
    }

    private void checkConformsToRegexes(D value) {
        this.superSet().forEach(sup -> {
            String regex = sup.getRegex();
            if (regex != null && !Pattern.matches(regex, (String)value)) {
                throw GraknTxOperationException.regexFailure((AttributeType)this, (String)((String)value), (String)regex);
            }
        });
    }

    public Attribute<D> getAttribute(D value) {
        String index = Schema.generateAttributeIndex((Label)this.getLabel(), (String)value.toString());
        return this.vertex().tx().getConcept(Schema.VertexProperty.INDEX, index).orElse(null);
    }

    public AttributeType.DataType<D> getDataType() {
        return (AttributeType.DataType)AttributeType.DataType.SUPPORTED_TYPES.get(this.vertex().property(Schema.VertexProperty.DATA_TYPE));
    }

    public String getRegex() {
        return (String)this.vertex().property(Schema.VertexProperty.REGEX);
    }
}

