/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.cache.ContainsTxCache;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.Shard;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class ConceptImpl
implements Concept,
ConceptVertex,
ContainsTxCache {
    private final Cache<Shard> currentShard = new Cache<Shard>(Cacheable.shard(), () -> {
        String currentShardId = (String)this.vertex().property(Schema.VertexProperty.CURRENT_SHARD);
        Vertex shardVertex = (Vertex)this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)currentShardId).next();
        Optional<Shard> shard = this.vertex().tx().factory().buildShard(shardVertex);
        return shard.orElseThrow(() -> GraknTxOperationException.missingShard((ConceptId)this.getId()));
    });
    private final Cache<ConceptId> conceptId = new Cache<ConceptId>(Cacheable.conceptId(), () -> ConceptId.of((String)((String)this.vertex().property(Schema.VertexProperty.ID))));
    private final VertexElement vertexElement;

    ConceptImpl(VertexElement vertexElement) {
        this.vertexElement = vertexElement;
    }

    @Override
    public VertexElement vertex() {
        return this.vertexElement;
    }

    <X extends Concept> X getThis() {
        return (X)this;
    }

    public void delete() throws GraknTxOperationException {
        this.deleteNode();
    }

    public boolean isDeleted() {
        return this.vertex().isDeleted();
    }

    public void deleteNode() {
        this.vertex().tx().txCache().remove(this);
        this.vertex().delete();
    }

    <X extends Concept> Stream<X> neighbours(Direction direction, Schema.EdgeLabel label) {
        switch (direction) {
            case BOTH: {
                return this.vertex().getEdgesOfType(direction, label).flatMap(edge -> Stream.of(edge.source().flatMap(source -> this.vertex().tx().factory().buildConcept((VertexElement)source)), edge.target().flatMap(target -> this.vertex().tx().factory().buildConcept((VertexElement)target)))).flatMap(CommonUtil::optionalToStream);
            }
            case IN: {
                return this.vertex().getEdgesOfType(direction, label).flatMap(edge -> {
                    Optional optional = edge.source().flatMap(source -> this.vertex().tx().factory().buildConcept((VertexElement)source));
                    return CommonUtil.optionalToStream(optional);
                });
            }
            case OUT: {
                return this.vertex().getEdgesOfType(direction, label).flatMap(edge -> {
                    Optional optional = edge.target().flatMap(target -> this.vertex().tx().factory().buildConcept((VertexElement)target));
                    return CommonUtil.optionalToStream(optional);
                });
            }
        }
        throw GraknTxOperationException.invalidDirection((Direction)direction);
    }

    EdgeElement putEdge(ConceptVertex to, Schema.EdgeLabel label) {
        return this.vertex().putEdge(to.vertex(), label);
    }

    public EdgeElement addEdge(ConceptVertex to, Schema.EdgeLabel label) {
        return this.vertex().addEdge(to.vertex(), label);
    }

    void deleteEdge(Direction direction, Schema.EdgeLabel label, Concept ... to) {
        if (to.length == 0) {
            this.vertex().deleteEdge(direction, label, new VertexElement[0]);
        } else {
            VertexElement[] targets = new VertexElement[to.length];
            for (int i = 0; i < to.length; ++i) {
                targets[i] = ((ConceptImpl)to[i]).vertex();
            }
            this.vertex().deleteEdge(direction, label, targets);
        }
    }

    public Schema.BaseType baseType() {
        return Schema.BaseType.valueOf((String)this.vertex().label());
    }

    public ConceptId getId() {
        return this.conceptId.get();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConceptImpl concept = (ConceptImpl)object;
        return this.getId().equals(concept.getId());
    }

    public final String toString() {
        if (this.vertex().tx().validElement((Element)this.vertex().element())) {
            return this.innerToString();
        }
        return "Id [" + this.getId() + "]";
    }

    String innerToString() {
        String message = "Base Type [" + this.baseType() + "] ";
        if (this.getId() != null) {
            message = message + "- Id [" + this.getId() + "] ";
        }
        return message;
    }

    public int compareTo(Concept o) {
        return this.getId().compareTo(o.getId());
    }

    public void createShard() {
        VertexElement shardVertex = this.vertex().tx().addVertexElement(Schema.BaseType.SHARD, new ConceptId[0]);
        Shard shard = this.vertex().tx().factory().buildShard(this, shardVertex);
        this.vertex().property(Schema.VertexProperty.CURRENT_SHARD, shard.id());
        this.currentShard.set(shard);
    }

    public Stream<Shard> shards() {
        return this.vertex().getEdgesOfType(Direction.IN, Schema.EdgeLabel.SHARD).map(EdgeElement::source).flatMap(CommonUtil::optionalToStream).map(edge -> this.vertex().tx().factory().buildShard((VertexElement)edge));
    }

    public Shard currentShard() {
        return this.currentShard.get();
    }

    public long getShardCount() {
        Long value = (Long)this.vertex().property(Schema.VertexProperty.SHARD_COUNT);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void setShardCount(Long instanceCount) {
        this.vertex().property(Schema.VertexProperty.SHARD_COUNT, instanceCount);
    }
}

