/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.RelationshipStructure;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipEdge
implements RelationshipStructure {
    private final Logger LOG = LoggerFactory.getLogger(RelationshipEdge.class);
    private final EdgeElement edgeElement;
    private final Cache<RelationshipType> relationType = new Cache<RelationshipType>(Cacheable.concept(), () -> (RelationshipType)this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID)))));
    private final Cache<Role> ownerRole = new Cache<Role>(Cacheable.concept(), () -> (Role)this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_ROLE_OWNER_LABEL_ID)))));
    private final Cache<Role> valueRole = new Cache<Role>(Cacheable.concept(), () -> (Role)this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_ROLE_VALUE_LABEL_ID)))));
    private final Cache<Thing> owner = new Cache<Thing>(Cacheable.concept(), () -> (Thing)this.edge().source().flatMap(vertexElement -> this.edge().tx().factory().buildConcept((VertexElement)vertexElement)).orElseThrow(() -> GraknTxOperationException.missingOwner((ConceptId)this.getId())));
    private final Cache<Thing> value = new Cache<Thing>(Cacheable.concept(), () -> (Thing)this.edge().target().flatMap(vertexElement -> this.edge().tx().factory().buildConcept((VertexElement)vertexElement)).orElseThrow(() -> GraknTxOperationException.missingValue((ConceptId)this.getId())));

    private RelationshipEdge(EdgeElement edgeElement) {
        this.edgeElement = edgeElement;
    }

    private RelationshipEdge(RelationshipType relationshipType, Role ownerRole, Role valueRole, EdgeElement edgeElement) {
        this(edgeElement);
        edgeElement.propertyImmutable(Schema.EdgeProperty.RELATIONSHIP_ROLE_OWNER_LABEL_ID, ownerRole, null, o -> o.getLabelId().getValue());
        edgeElement.propertyImmutable(Schema.EdgeProperty.RELATIONSHIP_ROLE_VALUE_LABEL_ID, valueRole, null, v -> v.getLabelId().getValue());
        edgeElement.propertyImmutable(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID, relationshipType, null, t -> t.getLabelId().getValue());
        this.relationType.set(relationshipType);
        this.ownerRole.set(ownerRole);
        this.valueRole.set(valueRole);
    }

    public static RelationshipEdge get(EdgeElement edgeElement) {
        return new RelationshipEdge(edgeElement);
    }

    public static RelationshipEdge create(RelationshipType relationshipType, Role ownerRole, Role valueRole, EdgeElement edgeElement) {
        return new RelationshipEdge(relationshipType, ownerRole, valueRole, edgeElement);
    }

    private EdgeElement edge() {
        return this.edgeElement;
    }

    @Override
    public ConceptId getId() {
        return ConceptId.of((String)this.edge().id().getValue());
    }

    @Override
    public RelationshipReified reify() {
        this.LOG.debug("Reifying concept [" + this.getId() + "]");
        VertexElement relationVertex = this.edge().tx().addVertexElement(Schema.BaseType.RELATIONSHIP, this.getId());
        RelationshipReified relationReified = this.edge().tx().factory().buildRelationReified(relationVertex, this.type());
        this.delete();
        return relationReified;
    }

    @Override
    public boolean isReified() {
        return false;
    }

    @Override
    public RelationshipType type() {
        return this.relationType.get();
    }

    @Override
    public Map<Role, Set<Thing>> allRolePlayers() {
        HashMap<Role, Set<Thing>> result = new HashMap<Role, Set<Thing>>();
        result.put(this.ownerRole(), Collections.singleton(this.owner()));
        result.put(this.valueRole(), Collections.singleton(this.value()));
        return result;
    }

    @Override
    public Stream<Thing> rolePlayers(Role ... roles) {
        if (roles.length == 0) {
            return Stream.of(this.owner(), this.value());
        }
        HashSet<Thing> result = new HashSet<Thing>();
        for (Role role : roles) {
            if (role.equals(this.ownerRole())) {
                result.add(this.owner());
                continue;
            }
            if (!role.equals(this.valueRole())) continue;
            result.add(this.value());
        }
        return result.stream();
    }

    @Override
    public void txCacheClear() {
        this.relationType.clear();
        this.ownerRole.clear();
        this.valueRole.clear();
        this.owner.clear();
        this.value.clear();
    }

    public Role ownerRole() {
        return this.ownerRole.get();
    }

    public Thing owner() {
        return this.owner.get();
    }

    public Role valueRole() {
        return this.valueRole.get();
    }

    public Thing value() {
        return this.value.get();
    }

    @Override
    public void delete() {
        this.edge().delete();
    }

    @Override
    public boolean isDeleted() {
        return this.edgeElement.isDeleted();
    }

    public String toString() {
        return "ID [" + this.getId() + "] Type [" + this.type().getLabel() + "] Roles and Role Players: \nRole [" + this.ownerRole().getLabel() + "] played by [" + this.owner().getId() + "] \nRole [" + this.valueRole().getLabel() + "] played by [" + this.value().getId() + "] \n";
    }
}

