/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.cache.ContainsTxCache;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.RelationshipStructure;
import ai.grakn.kb.internal.concept.ThingImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class RelationshipImpl
implements Relationship,
ConceptVertex,
ContainsTxCache {
    private RelationshipStructure relationshipStructure;

    private RelationshipImpl(RelationshipStructure relationshipStructure) {
        this.relationshipStructure = relationshipStructure;
    }

    public static RelationshipImpl create(RelationshipStructure relationshipStructure) {
        return new RelationshipImpl(relationshipStructure);
    }

    public Optional<RelationshipReified> reified() {
        if (!this.relationshipStructure.isReified()) {
            return Optional.empty();
        }
        return Optional.of(this.relationshipStructure.reify());
    }

    public RelationshipReified reify() {
        if (this.relationshipStructure.isReified()) {
            return this.relationshipStructure.reify();
        }
        Map<Role, Set<Thing>> rolePlayers = this.structure().allRolePlayers();
        this.relationshipStructure = this.relationshipStructure.reify();
        rolePlayers.forEach((role, things) -> {
            Thing thing = (Thing)Iterables.getOnlyElement((Iterable)things);
            this.addRolePlayer((Role)role, thing);
        });
        return this.relationshipStructure.reify();
    }

    public RelationshipStructure structure() {
        return this.relationshipStructure;
    }

    public Relationship attribute(Attribute attribute) {
        this.attributeRelationship(attribute);
        return this;
    }

    public Relationship attributeRelationship(Attribute attribute) {
        return this.reify().attributeRelationship(attribute);
    }

    public Stream<Attribute<?>> attributes(AttributeType[] attributeTypes) {
        return this.readFromReified(relationReified -> relationReified.attributes(attributeTypes));
    }

    public RelationshipType type() {
        return this.structure().type();
    }

    public Stream<Relationship> relationships(Role ... roles) {
        return this.readFromReified(relationReified -> relationReified.relationships(roles));
    }

    public Stream<Role> plays() {
        return this.readFromReified(ThingImpl::plays);
    }

    private <X> Stream<X> readFromReified(Function<RelationshipReified, Stream<X>> producer) {
        return this.reified().map(producer).orElseGet(Stream::empty);
    }

    public Map<Role, Set<Thing>> allRolePlayers() {
        return this.structure().allRolePlayers();
    }

    public Stream<Thing> rolePlayers(Role ... roles) {
        return this.structure().rolePlayers(roles);
    }

    public Relationship addRolePlayer(Role role, Thing thing) {
        this.reify().addRolePlayer(role, thing);
        this.vertex().tx().txCache().trackForValidation((Concept)this);
        return this;
    }

    public Relationship deleteAttribute(Attribute attribute) {
        this.reified().ifPresent(rel -> {
            Relationship cfr_ignored_0 = (Relationship)rel.deleteAttribute(attribute);
        });
        return this;
    }

    void cleanUp() {
        Stream<Thing> rolePlayers = this.rolePlayers(new Role[0]);
        boolean performDeletion = rolePlayers.noneMatch(thing -> thing != null && thing.getId() != null);
        if (performDeletion) {
            this.delete();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getId().equals(((RelationshipImpl)object).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.structure().toString();
    }

    public ConceptId getId() {
        return this.structure().getId();
    }

    public void delete() {
        this.structure().delete();
    }

    public boolean isDeleted() {
        return this.structure().isDeleted();
    }

    public int compareTo(Concept o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public VertexElement vertex() {
        return this.reify().vertex();
    }

    public static RelationshipImpl from(Relationship relationship) {
        return (RelationshipImpl)relationship;
    }

    @Override
    public void txCacheClear() {
        this.structure().txCacheClear();
    }
}

