/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.concept.RelationshipStructure;
import ai.grakn.kb.internal.concept.ThingImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import ai.grakn.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class RelationshipReified
extends ThingImpl<Relationship, RelationshipType>
implements RelationshipStructure {
    private RelationshipReified(VertexElement vertexElement) {
        super(vertexElement);
    }

    private RelationshipReified(VertexElement vertexElement, RelationshipType type) {
        super(vertexElement, type);
    }

    public static RelationshipReified get(VertexElement vertexElement) {
        return new RelationshipReified(vertexElement);
    }

    public static RelationshipReified create(VertexElement vertexElement, RelationshipType type) {
        return new RelationshipReified(vertexElement, type);
    }

    @Override
    public Map<Role, Set<Thing>> allRolePlayers() {
        HashMap<Role, Set<Thing>> roleMap = new HashMap<Role, Set<Thing>>();
        ((RelationshipType)this.type()).relates().forEach(roleType -> {
            Set cfr_ignored_0 = roleMap.put((Role)roleType, new HashSet());
        });
        this.castingsRelation(new Role[0]).forEach(rp -> roleMap.computeIfAbsent(rp.getRole(), k -> new HashSet()).add(rp.getRolePlayer()));
        return roleMap;
    }

    @Override
    public Stream<Thing> rolePlayers(Role ... roles) {
        return this.castingsRelation(roles).map(Casting::getRolePlayer);
    }

    public void addRolePlayer(Role role, Thing thing) {
        Objects.requireNonNull(role);
        Objects.requireNonNull(thing);
        if (Schema.MetaSchema.isMetaLabel((Label)role.getLabel())) {
            throw GraknTxOperationException.metaTypeImmutable((Label)role.getLabel());
        }
        this.vertex().tx().putShortcutEdge(thing, this, role);
    }

    public void setHash(String hash) {
        this.vertex().propertyUnique(Schema.VertexProperty.INDEX, hash);
    }

    public static String generateNewHash(RelationshipType relationshipType, Map<Role, Set<Thing>> roleMap) {
        TreeSet<Role> sortedRoleIds = new TreeSet<Role>(roleMap.keySet());
        StringBuilder hash = new StringBuilder();
        hash.append("RelationType_").append(StringUtil.escapeString((String)relationshipType.getId().getValue())).append("_Relation");
        for (Role role : sortedRoleIds) {
            hash.append("_").append(StringUtil.escapeString((String)role.getId().getValue()));
            roleMap.get(role).forEach(instance -> {
                if (instance != null) {
                    hash.append("_").append(StringUtil.escapeString((String)instance.getId().getValue()));
                }
            });
        }
        return hash.toString();
    }

    public static String generateNewHash(RelationshipType relationshipType, TreeMap<String, String> resourceMap) {
        StringBuilder hashMain = new StringBuilder();
        hashMain.append("RelationType_").append(StringUtil.escapeString((String)relationshipType.getId().getValue())).append("_");
        StringBuilder hashResourceTypes = new StringBuilder();
        hashResourceTypes.append("ResourceTypes_");
        StringBuilder hashResources = new StringBuilder();
        hashResources.append("Resources_");
        resourceMap.forEach((resourceTypeId, resourceId) -> {
            hashResourceTypes.append(StringUtil.escapeString((String)resourceTypeId)).append("_");
            hashResources.append(StringUtil.escapeString((String)resourceId)).append("_");
        });
        return hashMain.append((CharSequence)hashResourceTypes).append((CharSequence)hashResources).toString();
    }

    public Stream<Casting> castingsRelation(Role ... roles) {
        if (roles.length == 0) {
            return this.vertex().getEdgesOfType(Direction.OUT, Schema.EdgeLabel.ROLE_PLAYER).map(edge -> this.vertex().tx().factory().buildCasting((EdgeElement)edge));
        }
        Set roleTypesIds = Arrays.stream(roles).map(r -> r.getLabelId().getValue()).collect(Collectors.toSet());
        return this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.getId().getValue()).outE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID.name(), (Object)((RelationshipType)this.type()).getLabelId().getValue()).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), P.within(roleTypesIds)).toStream().map(edge -> this.vertex().tx().factory().buildCasting((Edge)edge));
    }

    @Override
    public String innerToString() {
        StringBuilder description = new StringBuilder();
        description.append("ID [").append(this.getId()).append("] Type [").append(((RelationshipType)this.type()).getLabel()).append("] Roles and Role Players: \n");
        for (Map.Entry<Role, Set<Thing>> entry : this.allRolePlayers().entrySet()) {
            if (entry.getValue().isEmpty()) {
                description.append("    Role [").append(entry.getKey().getLabel()).append("] not played by any instance \n");
                continue;
            }
            StringBuilder instancesString = new StringBuilder();
            for (Thing thing : entry.getValue()) {
                instancesString.append(thing.getId()).append(",");
            }
            description.append("    Role [").append(entry.getKey().getLabel()).append("] played by [").append(instancesString.toString()).append("] \n");
        }
        return description.toString();
    }

    @Override
    public RelationshipReified reify() {
        return this;
    }

    @Override
    public boolean isReified() {
        return true;
    }
}

