/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class ThingImpl<T extends Thing, V extends Type>
extends ConceptImpl
implements Thing {
    private final Cache<Label> cachedInternalType = new Cache<Label>(Cacheable.label(), () -> {
        int typeId = (Integer)this.vertex().property(Schema.VertexProperty.THING_TYPE_LABEL_ID);
        Optional type = this.vertex().tx().getConcept(Schema.VertexProperty.LABEL_ID, typeId);
        return ((Type)type.orElseThrow(() -> GraknTxOperationException.missingType((ConceptId)this.getId()))).getLabel();
    });
    private final Cache<V> cachedType = new Cache<Type>(Cacheable.concept(), () -> {
        Optional type = this.vertex().getEdgesOfType(Direction.OUT, Schema.EdgeLabel.ISA).map(EdgeElement::target).flatMap(CommonUtil::optionalToStream).flatMap(edge -> edge.getEdgesOfType(Direction.OUT, Schema.EdgeLabel.SHARD)).map(EdgeElement::target).flatMap(CommonUtil::optionalToStream).map(concept -> this.vertex().tx().factory().buildConcept((VertexElement)concept)).flatMap(CommonUtil::optionalToStream).findAny();
        return (Type)type.orElseThrow(() -> GraknTxOperationException.noType((Thing)this));
    });

    ThingImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    ThingImpl(VertexElement vertexElement, V type) {
        this(vertexElement);
        super.type((TypeImpl)type);
        super.track();
    }

    private void track() {
        if (this.type().keys().findAny().isPresent()) {
            this.vertex().tx().txCache().trackForValidation(this);
        }
    }

    @Override
    public void delete() {
        Set<Relationship> relationships = this.castingsInstance().map(Casting::getRelationship).collect(Collectors.toSet());
        this.vertex().tx().txCache().removedInstance(this.type().getId());
        this.deleteNode();
        relationships.forEach(relation -> {
            if (relation.type().isImplicit().booleanValue()) {
                relation.delete();
            } else {
                RelationshipImpl rel = (RelationshipImpl)relation;
                this.vertex().tx().txCache().trackForValidation((Concept)rel);
                rel.cleanUp();
            }
        });
    }

    @Override
    public void txCacheClear() {
        this.cachedInternalType.clear();
        this.cachedType.clear();
    }

    public String getIndex() {
        return (String)this.vertex().property(Schema.VertexProperty.INDEX);
    }

    public Stream<Attribute<?>> attributes(AttributeType ... attributeTypes) {
        Set<ConceptId> attributeTypesIds = Arrays.stream(attributeTypes).map(Concept::getId).collect(Collectors.toSet());
        return this.attributes(this.getShortcutNeighbours(), attributeTypesIds);
    }

    private <X extends Concept> Stream<Attribute<?>> attributes(Stream<X> conceptStream, Set<ConceptId> attributeTypesIds) {
        Stream<Attribute<?>> attributeStream = conceptStream.filter(concept -> concept.isAttribute() && !this.equals(concept)).map(Concept::asAttribute);
        if (!attributeTypesIds.isEmpty()) {
            attributeStream = attributeStream.filter(attribute -> attributeTypesIds.contains(attribute.type().getId()));
        }
        return attributeStream;
    }

    Stream<Casting> castingsInstance() {
        return this.vertex().getEdgesOfType(Direction.IN, Schema.EdgeLabel.ROLE_PLAYER).map(edge -> this.vertex().tx().factory().buildCasting((EdgeElement)edge));
    }

    <X extends Thing> Stream<X> getShortcutNeighbours() {
        GraphTraversal shortcutTraversal = __.inE((String[])new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).as("edge", new String[0]).outV().outE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).where(P.neq((Object)"edge")).inV();
        GraphTraversal attributeEdgeTraversal = __.outE((String[])new String[]{Schema.EdgeLabel.ATTRIBUTE.getLabel()}).inV();
        return this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.getId().getValue()).union(new Traversal[]{shortcutTraversal, attributeEdgeTraversal}).toStream().map(vertex -> this.vertex().tx().buildConcept((Vertex)vertex)).flatMap(CommonUtil::optionalToStream);
    }

    public Stream<Relationship> relationships(Role ... roles) {
        return Stream.concat(this.reifiedRelations(roles), this.edgeRelations(roles));
    }

    private Stream<Relationship> reifiedRelations(Role ... roles) {
        GraphTraversal traversal = this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.getId().getValue());
        if (roles.length == 0) {
            traversal.in(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()});
        } else {
            Set roleTypesIds = Arrays.stream(roles).map(r -> r.getLabelId().getValue()).collect(Collectors.toSet());
            traversal.inE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), P.within(roleTypesIds)).outV();
        }
        return traversal.toStream().map(vertex -> this.vertex().tx().buildConcept((Vertex)vertex)).flatMap(CommonUtil::optionalToStream);
    }

    private Stream<Relationship> edgeRelations(Role ... roles) {
        HashSet<Role> roleSet = new HashSet<Role>(Arrays.asList(roles));
        Stream<EdgeElement> stream = this.vertex().getEdgesOfType(Direction.BOTH, Schema.EdgeLabel.ATTRIBUTE);
        if (!roleSet.isEmpty()) {
            stream = stream.filter(edge -> {
                Role roleOwner = (Role)this.vertex().tx().getSchemaConcept(LabelId.of((Integer)((Integer)edge.property(Schema.EdgeProperty.RELATIONSHIP_ROLE_OWNER_LABEL_ID))));
                return roleSet.contains(roleOwner);
            });
        }
        return stream.map(edge -> this.vertex().tx().factory().buildRelation((EdgeElement)edge));
    }

    public Stream<Role> plays() {
        return this.castingsInstance().map(Casting::getRole);
    }

    public T attribute(Attribute attribute) {
        this.attributeRelationship(attribute);
        return (T)((Thing)this.getThis());
    }

    public Relationship attributeRelationship(Attribute attribute) {
        Schema.ImplicitType has = Schema.ImplicitType.HAS;
        Schema.ImplicitType hasValue = Schema.ImplicitType.HAS_VALUE;
        Schema.ImplicitType hasOwner = Schema.ImplicitType.HAS_OWNER;
        if (this.type().keys().anyMatch(rt -> rt.equals(attribute.type()))) {
            has = Schema.ImplicitType.KEY;
            hasValue = Schema.ImplicitType.KEY_VALUE;
            hasOwner = Schema.ImplicitType.KEY_OWNER;
        }
        Label label = attribute.type().getLabel();
        RelationshipType hasAttribute = (RelationshipType)this.vertex().tx().getSchemaConcept(has.getLabel(label));
        Role hasAttributeOwner = (Role)this.vertex().tx().getSchemaConcept(hasOwner.getLabel(label));
        Role hasAttributeValue = (Role)this.vertex().tx().getSchemaConcept(hasValue.getLabel(label));
        if (hasAttribute == null || hasAttributeOwner == null || hasAttributeValue == null || this.type().plays().noneMatch(play -> play.equals(hasAttributeOwner))) {
            throw GraknTxOperationException.hasNotAllowed((Thing)this, (Attribute)attribute);
        }
        EdgeElement attributeEdge = this.putEdge(AttributeImpl.from(attribute), Schema.EdgeLabel.ATTRIBUTE);
        return this.vertex().tx().factory().buildRelation(attributeEdge, hasAttribute, hasAttributeOwner, hasAttributeValue);
    }

    public T deleteAttribute(Attribute attribute) {
        Role roleHasOwner = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.HAS_OWNER.getLabel(attribute.type().getLabel()));
        Role roleKeyOwner = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.KEY_OWNER.getLabel(attribute.type().getLabel()));
        Role roleHasValue = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.HAS_VALUE.getLabel(attribute.type().getLabel()));
        Role roleKeyValue = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.KEY_VALUE.getLabel(attribute.type().getLabel()));
        Stream<Relationship> relationships = this.relationships(this.filterNulls(roleHasOwner, roleKeyOwner));
        relationships.filter(relationship -> {
            Stream rolePlayers = relationship.rolePlayers(this.filterNulls(roleHasValue, roleKeyValue));
            return rolePlayers.anyMatch(rolePlayer -> rolePlayer.equals(attribute));
        }).forEach(Concept::delete);
        return (T)((Thing)this.getThis());
    }

    private Role[] filterNulls(Role ... roles) {
        return (Role[])Arrays.stream(roles).filter(Objects::nonNull).toArray(Role[]::new);
    }

    public V type() {
        return (V)((Type)this.cachedType.get());
    }

    private void type(TypeImpl type) {
        if (type != null) {
            this.cachedType.set(type);
            type.currentShard().link(this);
            this.setInternalType(type);
        }
    }

    private void setInternalType(Type type) {
        this.cachedInternalType.set(type.getLabel());
        this.vertex().property(Schema.VertexProperty.THING_TYPE_LABEL_ID, type.getLabelId().getValue());
    }

    Label getInternalType() {
        return this.cachedInternalType.get();
    }
}

