/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.structure;

import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;

public class Casting {
    private final EdgeElement edgeElement;
    private final Cache<Role> cachedRoleType = new Cache<Role>(Cacheable.concept(), () -> (Role)this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.ROLE_LABEL_ID)))));
    private final Cache<RelationshipType> cachedRelationType = new Cache<RelationshipType>(Cacheable.concept(), () -> (RelationshipType)this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID)))));
    private final Cache<Thing> cachedInstance = new Cache<Thing>(Cacheable.concept(), () -> (Thing)this.edge().target().flatMap(vertexElement -> this.edge().tx().factory().buildConcept((VertexElement)vertexElement)).orElseThrow(() -> GraknTxOperationException.missingRolePlayer((String)this.edge().id().getValue())));
    private final Cache<Relationship> cachedRelation = new Cache<Relationship>(Cacheable.concept(), () -> (Relationship)this.edge().source().flatMap(vertexElement -> this.edge().tx().factory().buildConcept((VertexElement)vertexElement)).orElseThrow(() -> GraknTxOperationException.missingRelationship((String)this.edge().id().getValue())));

    public Casting(EdgeElement edgeElement) {
        this.edgeElement = edgeElement;
    }

    private EdgeElement edge() {
        return this.edgeElement;
    }

    public Role getRole() {
        return this.cachedRoleType.get();
    }

    public RelationshipType getRelationshipType() {
        return this.cachedRelationType.get();
    }

    public Relationship getRelationship() {
        return this.cachedRelation.get();
    }

    public Thing getRolePlayer() {
        return this.cachedInstance.get();
    }

    public int hashCode() {
        return this.edge().id().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Casting casting = (Casting)object;
        return this.edge().id().equals(casting.edge().id());
    }
}

