/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.structure;

import ai.grakn.kb.internal.GraknTxAbstract;
import ai.grakn.kb.internal.structure.AbstractElement;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.util.Schema;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class VertexElement
extends AbstractElement<Vertex, Schema.VertexProperty> {
    public VertexElement(GraknTxAbstract graknTx, Vertex element) {
        super(graknTx, element, "V");
    }

    public Stream<EdgeElement> getEdgesOfType(Direction direction, Schema.EdgeLabel label) {
        Iterable iterable = () -> ((Vertex)this.element()).edges(direction, new String[]{label.getLabel()});
        return StreamSupport.stream(iterable.spliterator(), false).map(edge -> this.tx().factory().buildEdgeElement((Edge)edge));
    }

    public EdgeElement addEdge(VertexElement to, Schema.EdgeLabel type) {
        return this.tx().factory().buildEdgeElement(((Vertex)this.element()).addEdge(type.getLabel(), (Vertex)to.element(), new Object[0]));
    }

    public EdgeElement putEdge(VertexElement to, Schema.EdgeLabel type) {
        GraphTraversal traversal = this.tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.id().getValue()).outE(new String[]{type.getLabel()}).as("edge", new String[0]).otherV().has(Schema.VertexProperty.ID.name(), (Object)to.id().getValue()).select("edge");
        if (!traversal.hasNext()) {
            return this.addEdge(to, type);
        }
        return this.tx().factory().buildEdgeElement((Edge)traversal.next());
    }

    public void deleteEdge(Direction direction, Schema.EdgeLabel label, VertexElement ... targets) {
        Iterator edges = ((Vertex)this.element()).edges(direction, new String[]{label.getLabel()});
        if (targets.length == 0) {
            edges.forEachRemaining(Element::remove);
        } else {
            Set verticesToDelete = Arrays.stream(targets).map(AbstractElement::element).collect(Collectors.toSet());
            edges.forEachRemaining(edge -> {
                boolean delete = false;
                switch (direction) {
                    case BOTH: {
                        delete = verticesToDelete.contains(edge.inVertex()) || verticesToDelete.contains(edge.outVertex());
                        break;
                    }
                    case IN: {
                        delete = verticesToDelete.contains(edge.outVertex());
                        break;
                    }
                    case OUT: {
                        delete = verticesToDelete.contains(edge.inVertex());
                    }
                }
                if (delete) {
                    edge.remove();
                }
            });
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Vertex [").append(this.id()).append("] /n");
        ((Vertex)this.element()).properties(new String[0]).forEachRemaining(p -> stringBuilder.append("Property [").append(p.key()).append("] value [").append(p.value()).append("] /n"));
        return stringBuilder.toString();
    }
}

