/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.util;

import ai.grakn.util.ErrorMessage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineCommunicator {
    private static final Logger LOG = LoggerFactory.getLogger(EngineCommunicator.class);
    private static final String DEFAULT_PROTOCOL = "http://";
    private static final int MAX_RETRY = 5;

    public static String contactEngine(String engineUrl, String restType, @Nullable String body) {
        if (engineUrl.equals("in-memory")) {
            return "Engine not contacted due to in memory graph being used";
        }
        for (int i = 0; i < 5; ++i) {
            try {
                URL url = new URL(DEFAULT_PROTOCOL + engineUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestMethod(restType);
                if (body != null) {
                    connection.setDoOutput(true);
                    try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                        wr.write(body.getBytes(StandardCharsets.UTF_8));
                    }
                }
                if (connection.getResponseCode() != 200) {
                    throw new IllegalArgumentException(ErrorMessage.INVALID_ENGINE_RESPONSE.getMessage(new Object[]{engineUrl, connection.getResponseCode()}));
                }
                StringBuilder sb = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append("\n").append(line);
                    }
                }
                return sb.toString();
            }
            catch (IOException e) {
                LOG.error(ErrorMessage.COULD_NOT_REACH_ENGINE.getMessage(new Object[]{engineUrl}), (Throwable)e);
                continue;
            }
        }
        throw new RuntimeException(ErrorMessage.COULD_NOT_REACH_ENGINE.getMessage(new Object[]{engineUrl}));
    }

    public static String contactEngine(String engineUrl, String restType) {
        return EngineCommunicator.contactEngine(engineUrl, restType, null);
    }
}

