/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.util;

import ai.grakn.GraknSystemProperty;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.factory.FactoryBuilder;
import ai.grakn.factory.TxFactory;
import ai.grakn.graql.Query;
import ai.grakn.kb.internal.GraknTxAbstract;
import ai.grakn.kb.internal.GraknTxTinker;
import com.google.common.base.StandardSystemProperty;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SampleKBLoader {
    private static final AtomicBoolean propertiesLoaded = new AtomicBoolean(false);
    private static Properties graphConfig;
    private final TxFactory<?> factory = FactoryBuilder.getFactory(SampleKBLoader.randomKeyspace(), "in-memory", SampleKBLoader.properties());
    @Nullable
    private Consumer<GraknTx> preLoad;
    private boolean graphLoaded = false;
    private GraknTx tx;

    protected SampleKBLoader(@Nullable Consumer<GraknTx> preLoad) {
        this.preLoad = preLoad;
    }

    public static SampleKBLoader empty() {
        return new SampleKBLoader(null);
    }

    public static SampleKBLoader preLoad(Consumer<GraknTx> build) {
        return new SampleKBLoader(build);
    }

    public static SampleKBLoader preLoad(String[] files) {
        return new SampleKBLoader(graknGraph -> {
            for (String file : files) {
                SampleKBLoader.loadFromFile(graknGraph, file);
            }
        });
    }

    public GraknTx tx() {
        if (this.tx == null || this.tx.isClosed()) {
            if (!this.graphLoaded) {
                try (GraknTxAbstract<?> graph = this.factory.open(GraknTxType.WRITE);){
                    this.load(graph);
                    graph.commit();
                    this.graphLoaded = true;
                }
            }
            this.tx = this.factory.open(GraknTxType.WRITE);
        }
        return this.tx;
    }

    public void load(Consumer<GraknTx> preLoad) {
        this.preLoad = preLoad;
        this.graphLoaded = false;
        this.tx();
    }

    public void rollback() {
        if (this.tx instanceof GraknTxTinker) {
            this.tx.admin().delete();
            this.graphLoaded = false;
        } else if (!this.tx.isClosed()) {
            this.tx.close();
        }
        this.tx = this.tx();
    }

    private void load(GraknTx graph) {
        if (this.preLoad != null) {
            this.preLoad.accept(graph);
        }
    }

    private static Properties properties() {
        if (propertiesLoaded.compareAndSet(false, true)) {
            String configFilePath = GraknSystemProperty.CONFIGURATION_FILE.value();
            if (!Paths.get(configFilePath, new String[0]).isAbsolute()) {
                configFilePath = SampleKBLoader.getProjectPath() + configFilePath;
            }
            graphConfig = new Properties();
            try (FileInputStream inputStream = new FileInputStream(configFilePath);){
                graphConfig.load(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw GraknTxOperationException.invalidConfig((String)configFilePath);
            }
        }
        return graphConfig;
    }

    private static String getProjectPath() {
        if (GraknSystemProperty.CURRENT_DIRECTORY.value() == null) {
            GraknSystemProperty.CURRENT_DIRECTORY.set(StandardSystemProperty.USER_DIR.value());
        }
        return GraknSystemProperty.CURRENT_DIRECTORY.value() + "/";
    }

    public static Keyspace randomKeyspace() {
        return Keyspace.of((String)("a" + UUID.randomUUID().toString().replaceAll("-", "")));
    }

    public static void loadFromFile(GraknTx graph, String file) {
        try {
            File graql = new File(file);
            graph.graql().parseList(Files.readLines((File)graql, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"))).forEach(Query::execute);
        }
        catch (InvalidKBException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

