/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknConfigKey;
import ai.grakn.factory.EmbeddedGraknSession;
import ai.grakn.factory.TxFactory;
import ai.grakn.factory.TxFactoryBuilder;
import ai.grakn.util.ErrorMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;

public class GraknTxFactoryBuilder
extends TxFactoryBuilder {
    private static final Map<String, TxFactory<?>> openFactories = new ConcurrentHashMap();
    private static final Map<String, String> factoryMapper = ImmutableMap.of((Object)"in-memory", (Object)"ai.grakn.factory.TxFactoryTinker", (Object)"production", (Object)"ai.grakn.factory.TxFactoryJanus", (Object)"distributed", (Object)"ai.grakn.factory.TxFactoryJanusHadoop");
    private static TxFactoryBuilder instance = null;

    private GraknTxFactoryBuilder() {
    }

    public static synchronized TxFactoryBuilder getInstance() {
        if (instance == null) {
            instance = new GraknTxFactoryBuilder();
        }
        return instance;
    }

    @Override
    public TxFactory<?> getFactory(EmbeddedGraknSession session, boolean isComputerFactory) {
        try {
            String factoryKey = (String)session.config().getProperty(GraknConfigKey.KB_MODE);
            if (isComputerFactory) {
                factoryKey = (String)session.config().getProperty(GraknConfigKey.KB_ANALYTICS);
            }
            String factoryType = factoryMapper.get(factoryKey);
            return GraknTxFactoryBuilder.getFactory(factoryType, session);
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException(ErrorMessage.MISSING_FACTORY_DEFINITION.getMessage(new Object[0]));
        }
    }

    private static TxFactory<?> getFactory(String factoryType, EmbeddedGraknSession session) {
        String key = factoryType + session.keyspace();
        return openFactories.computeIfAbsent(key, k -> GraknTxFactoryBuilder.newFactory(factoryType, session));
    }

    @VisibleForTesting
    public static void refresh() {
        openFactories.clear();
    }
}

