/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.GraknConfigKey;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.QueryExecutor;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.exception.PropertyNotUniqueException;
import ai.grakn.factory.EmbeddedGraknSession;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.kb.admin.GraknAdmin;
import ai.grakn.kb.internal.Validator;
import ai.grakn.kb.internal.cache.GlobalCache;
import ai.grakn.kb.internal.cache.TxCache;
import ai.grakn.kb.internal.cache.TxRuleCache;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.ElementFactory;
import ai.grakn.kb.internal.concept.RelationshipEdge;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.kb.log.CommitLog;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EmbeddedGraknTx<G extends Graph>
implements GraknAdmin {
    final Logger LOG = LoggerFactory.getLogger(EmbeddedGraknTx.class);
    private static final String QUERY_BUILDER_CLASS_NAME = "ai.grakn.graql.internal.query.QueryBuilderImpl";
    private static final String QUERY_EXECUTOR_CLASS_NAME = "ai.grakn.graql.internal.query.executor.QueryExecutorImpl";
    private final EmbeddedGraknSession session;
    private final G graph;
    private final ElementFactory elementFactory;
    private final GlobalCache globalCache;
    @Nullable
    private static final Constructor<?> queryBuilderConstructor = EmbeddedGraknTx.getQueryBuilderConstructor();
    @Nullable
    private static final Method queryExecutorFactory = EmbeddedGraknTx.getQueryExecutorFactory();
    private final ThreadLocal<TxCache> localConceptLog = new ThreadLocal();
    @Nullable
    private GraphTraversalSource graphTraversalSource = null;
    private final TxRuleCache ruleCache;

    public EmbeddedGraknTx(EmbeddedGraknSession session, G graph) {
        this.session = session;
        this.graph = graph;
        this.elementFactory = new ElementFactory(this);
        this.ruleCache = new TxRuleCache(this);
        this.globalCache = new GlobalCache(session.config());
        this.txCache().openTx(GraknTxType.WRITE);
        if (this.initialiseMetaConcepts()) {
            this.commit();
        }
    }

    public EmbeddedGraknSession session() {
        return this.session;
    }

    public TxRuleCache ruleCache() {
        return this.ruleCache;
    }

    public LabelId convertToId(Label label) {
        if (this.txCache().isLabelCached(label)) {
            return this.txCache().convertLabelToId(label);
        }
        return LabelId.invalid();
    }

    private LabelId getNextId() {
        TypeImpl metaConcept = (TypeImpl)this.getMetaConcept();
        Integer currentValue = (Integer)metaConcept.vertex().property(Schema.VertexProperty.CURRENT_LABEL_ID);
        currentValue = currentValue == null ? Integer.valueOf(Schema.MetaSchema.values().length + 1) : Integer.valueOf(currentValue + 1);
        metaConcept.property(Schema.VertexProperty.CURRENT_LABEL_ID, currentValue);
        return LabelId.of((Integer)currentValue);
    }

    GlobalCache getGlobalCache() {
        return this.globalCache;
    }

    public abstract int numOpenTx();

    public void openTransaction(GraknTxType txType) {
        this.txCache().openTx(txType);
    }

    public long shardingThreshold() {
        return (Long)this.session().config().getProperty(GraknConfigKey.SHARDING_THRESHOLD);
    }

    public TxCache txCache() {
        TxCache txCache = this.localConceptLog.get();
        if (txCache == null) {
            txCache = new TxCache(this.getGlobalCache());
            this.localConceptLog.set(txCache);
        }
        if (txCache.isTxOpen() && txCache.schemaNotCached()) {
            txCache.refreshSchemaCache();
        }
        return txCache;
    }

    public boolean isClosed() {
        return !this.txCache().isTxOpen();
    }

    public abstract boolean isTinkerPopGraphClosed();

    public GraknTxType txType() {
        return this.txCache().txType();
    }

    public GraknAdmin admin() {
        return this;
    }

    public <T extends Concept> T buildConcept(Vertex vertex) {
        return (T)this.factory().buildConcept(vertex);
    }

    public <T extends Concept> T buildConcept(Edge edge) {
        return (T)this.factory().buildConcept(edge);
    }

    public boolean isBatchTx() {
        return GraknTxType.BATCH.equals((Object)this.txCache().txType());
    }

    private boolean initialiseMetaConcepts() {
        boolean schemaInitialised = false;
        if (this.isMetaSchemaNotInitialised()) {
            VertexElement type = this.addTypeVertex(Schema.MetaSchema.THING.getId(), Schema.MetaSchema.THING.getLabel(), Schema.BaseType.TYPE);
            VertexElement entityType = this.addTypeVertex(Schema.MetaSchema.ENTITY.getId(), Schema.MetaSchema.ENTITY.getLabel(), Schema.BaseType.ENTITY_TYPE);
            VertexElement relationType = this.addTypeVertex(Schema.MetaSchema.RELATIONSHIP.getId(), Schema.MetaSchema.RELATIONSHIP.getLabel(), Schema.BaseType.RELATIONSHIP_TYPE);
            VertexElement resourceType = this.addTypeVertex(Schema.MetaSchema.ATTRIBUTE.getId(), Schema.MetaSchema.ATTRIBUTE.getLabel(), Schema.BaseType.ATTRIBUTE_TYPE);
            this.addTypeVertex(Schema.MetaSchema.ROLE.getId(), Schema.MetaSchema.ROLE.getLabel(), Schema.BaseType.ROLE);
            this.addTypeVertex(Schema.MetaSchema.RULE.getId(), Schema.MetaSchema.RULE.getLabel(), Schema.BaseType.RULE);
            relationType.property(Schema.VertexProperty.IS_ABSTRACT, true);
            resourceType.property(Schema.VertexProperty.IS_ABSTRACT, true);
            entityType.property(Schema.VertexProperty.IS_ABSTRACT, true);
            relationType.addEdge(type, Schema.EdgeLabel.SUB);
            resourceType.addEdge(type, Schema.EdgeLabel.SUB);
            entityType.addEdge(type, Schema.EdgeLabel.SUB);
            schemaInitialised = true;
        }
        this.copyToCache((SchemaConcept)this.getMetaConcept());
        this.copyToCache((SchemaConcept)this.getMetaRole());
        this.copyToCache((SchemaConcept)this.getMetaRule());
        return schemaInitialised;
    }

    private void copyToCache(SchemaConcept schemaConcept) {
        schemaConcept.subs().forEach(concept -> {
            this.getGlobalCache().cacheLabel(concept.label(), concept.labelId());
            this.getGlobalCache().cacheType(concept.label(), (SchemaConcept)concept);
        });
    }

    private boolean isMetaSchemaNotInitialised() {
        return this.getMetaConcept() == null;
    }

    public G getTinkerPopGraph() {
        return this.graph;
    }

    public GraphTraversalSource getTinkerTraversal() {
        this.operateOnOpenGraph(() -> null);
        if (this.graphTraversalSource == null) {
            this.graphTraversalSource = this.getTinkerPopGraph().traversal().withStrategies(new TraversalStrategy[]{ReadOnlyStrategy.instance()});
        }
        return this.graphTraversalSource;
    }

    public QueryBuilder graql() {
        if (queryBuilderConstructor == null) {
            throw new RuntimeException(ErrorMessage.CANNOT_FIND_CLASS.getMessage(new Object[]{"query executor", QUERY_EXECUTOR_CLASS_NAME}));
        }
        try {
            return (QueryBuilder)queryBuilderConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ElementFactory factory() {
        return this.elementFactory;
    }

    public <T extends Concept> Optional<T> getConcept(Schema.VertexProperty key, Object value) {
        GraphTraversal vertices = this.getTinkerTraversal().V(new Object[0]).has(key.name(), value);
        if (vertices.hasNext()) {
            Vertex vertex = (Vertex)vertices.next();
            if (vertices.hasNext()) {
                this.LOG.warn(ErrorMessage.TOO_MANY_CONCEPTS.getMessage(new Object[]{key.name(), value}));
            }
            return Optional.of(this.factory().buildConcept(vertex));
        }
        return Optional.empty();
    }

    public final Stream<SchemaConcept> sups(SchemaConcept schemaConcept) {
        HashSet<SchemaConcept> superSet = new HashSet<SchemaConcept>();
        while (schemaConcept != null) {
            superSet.add(schemaConcept);
            schemaConcept = schemaConcept.sup();
        }
        return superSet.stream();
    }

    private Set<Concept> getConcepts(Schema.VertexProperty key, Object value) {
        HashSet<Concept> concepts = new HashSet<Concept>();
        this.getTinkerTraversal().V(new Object[0]).has(key.name(), value).forEachRemaining(v -> concepts.add((Concept)this.factory().buildConcept((Vertex)v)));
        return concepts;
    }

    public void checkSchemaMutationAllowed() {
        this.checkMutationAllowed();
        if (this.isBatchTx()) {
            throw GraknTxOperationException.schemaMutation();
        }
    }

    public void checkMutationAllowed() {
        if (GraknTxType.READ.equals((Object)this.txType())) {
            throw GraknTxOperationException.transactionReadOnly((GraknTx)this);
        }
    }

    public VertexElement addVertexElement(Schema.BaseType baseType, ConceptId ... conceptIds) {
        return this.factory().addVertexElement(baseType, conceptIds);
    }

    private VertexElement addTypeVertex(LabelId id, Label label, Schema.BaseType baseType) {
        VertexElement vertexElement = this.addVertexElement(baseType, new ConceptId[0]);
        vertexElement.property(Schema.VertexProperty.SCHEMA_LABEL, label.getValue());
        vertexElement.property(Schema.VertexProperty.LABEL_ID, id.getValue());
        return vertexElement;
    }

    private <X> X operateOnOpenGraph(Supplier<X> supplier) {
        if (this.isClosed()) {
            throw GraknTxOperationException.transactionClosed((GraknTx)this, (String)this.txCache().getClosedReason());
        }
        return supplier.get();
    }

    public EntityType putEntityType(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.ENTITY_TYPE, false, v -> this.factory().buildEntityType((VertexElement)v, this.getMetaEntityType()));
    }

    private <T extends SchemaConcept> T putSchemaConcept(Label label, Schema.BaseType baseType, boolean isImplicit, Function<VertexElement, T> newConceptFactory) {
        this.checkSchemaMutationAllowed();
        SchemaConceptImpl schemaConcept = (SchemaConceptImpl)this.getSchemaConcept(this.convertToId(label));
        if (schemaConcept == null) {
            if (!isImplicit && label.getValue().startsWith(Schema.ImplicitType.RESERVED.getValue())) {
                throw GraknTxOperationException.invalidLabelStart((Label)label);
            }
            VertexElement vertexElement = this.addTypeVertex(this.getNextId(), label, baseType);
            if (isImplicit) {
                vertexElement.property(Schema.VertexProperty.IS_IMPLICIT, true);
            }
            schemaConcept = SchemaConceptImpl.from(this.buildSchemaConcept(label, () -> (SchemaConcept)newConceptFactory.apply(vertexElement)));
        } else if (!baseType.equals((Object)schemaConcept.baseType())) {
            throw this.labelTaken(schemaConcept);
        }
        return (T)schemaConcept;
    }

    private GraknTxOperationException labelTaken(SchemaConcept schemaConcept) {
        if (Schema.MetaSchema.isMetaLabel((Label)schemaConcept.label())) {
            return GraknTxOperationException.reservedLabel((Label)schemaConcept.label());
        }
        return PropertyNotUniqueException.cannotCreateProperty((Concept)schemaConcept, (Schema.VertexProperty)Schema.VertexProperty.SCHEMA_LABEL, (Object)schemaConcept.label());
    }

    private <T extends Concept> T validateSchemaConcept(Concept concept, Schema.BaseType baseType, Supplier<T> invalidHandler) {
        if (concept != null && baseType.getClassType().isInstance(concept)) {
            return (T)concept;
        }
        return (T)((Concept)invalidHandler.get());
    }

    private SchemaConcept buildSchemaConcept(Label label, Supplier<SchemaConcept> dbBuilder) {
        if (this.txCache().isTypeCached(label)) {
            return this.txCache().getCachedSchemaConcept(label);
        }
        return dbBuilder.get();
    }

    public RelationshipType putRelationshipType(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.RELATIONSHIP_TYPE, false, v -> this.factory().buildRelationshipType((VertexElement)v, this.getMetaRelationType()));
    }

    public RelationshipType putRelationTypeImplicit(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.RELATIONSHIP_TYPE, true, v -> this.factory().buildRelationshipType((VertexElement)v, this.getMetaRelationType()));
    }

    public Role putRole(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.ROLE, false, v -> this.factory().buildRole((VertexElement)v, this.getMetaRole()));
    }

    public Role putRoleTypeImplicit(Label label) {
        return this.putSchemaConcept(label, Schema.BaseType.ROLE, true, v -> this.factory().buildRole((VertexElement)v, this.getMetaRole()));
    }

    public <V> AttributeType<V> putAttributeType(Label label, AttributeType.DataType<V> dataType) {
        AttributeType attributeType = this.putSchemaConcept(label, Schema.BaseType.ATTRIBUTE_TYPE, false, v -> this.factory().buildAttributeType((VertexElement)v, this.getMetaAttributeType(), dataType));
        if (Schema.MetaSchema.isMetaLabel((Label)label)) {
            throw GraknTxOperationException.metaTypeImmutable((Label)label);
        }
        if (!dataType.equals((Object)attributeType.dataType())) {
            throw GraknTxOperationException.immutableProperty((Object)attributeType.dataType(), dataType, (Enum)Schema.VertexProperty.DATA_TYPE);
        }
        return attributeType;
    }

    public Rule putRule(Label label, Pattern when, Pattern then) {
        Rule rule = this.putSchemaConcept(label, Schema.BaseType.RULE, false, v -> this.factory().buildRule((VertexElement)v, this.getMetaRule(), when, then));
        if (rule.then() != null) {
            rule.then().admin().varPatterns().stream().flatMap(v -> v.getTypeLabels().stream()).map(vl -> this.admin().getSchemaConcept(vl)).filter(Objects::nonNull).filter(Concept::isType).forEach(type -> this.ruleCache.updateRules((SchemaConcept)type, rule));
        }
        return rule;
    }

    public <T extends Concept> T getConcept(ConceptId id) {
        return (T)this.operateOnOpenGraph(() -> {
            Optional concept;
            if (this.txCache().isConceptCached(id)) {
                return this.txCache().getCachedConcept(id);
            }
            if (id.getValue().startsWith("E") && (concept = this.getConceptEdge(id)).isPresent()) {
                return (Concept)concept.get();
            }
            return this.getConcept(Schema.VertexProperty.ID, id.getValue()).orElse(null);
        });
    }

    private <T extends Concept> Optional<T> getConceptEdge(ConceptId id) {
        String edgeId = id.getValue().substring(1);
        GraphTraversal traversal = this.getTinkerTraversal().E(new Object[]{edgeId});
        if (traversal.hasNext()) {
            return Optional.of(this.factory().buildConcept(this.factory().buildEdgeElement((Edge)traversal.next())));
        }
        return Optional.empty();
    }

    private <T extends SchemaConcept> T getSchemaConcept(Label label, Schema.BaseType baseType) {
        this.operateOnOpenGraph(() -> null);
        SchemaConcept schemaConcept = this.buildSchemaConcept(label, () -> this.getSchemaConcept(this.convertToId(label)));
        return (T)this.validateSchemaConcept((Concept)schemaConcept, baseType, () -> null);
    }

    @Nullable
    public <T extends SchemaConcept> T getSchemaConcept(LabelId id) {
        if (!id.isValid()) {
            return null;
        }
        return (T)((SchemaConcept)this.getConcept(Schema.VertexProperty.LABEL_ID, id.getValue()).orElse(null));
    }

    public <V> Collection<Attribute<V>> getAttributesByValue(V value) {
        if (value == null) {
            return Collections.emptySet();
        }
        if (!AttributeType.DataType.SUPPORTED_TYPES.containsKey((Object)value.getClass().getName())) {
            throw GraknTxOperationException.unsupportedDataType(value);
        }
        HashSet attributes = new HashSet();
        AttributeType.DataType dataType = (AttributeType.DataType)AttributeType.DataType.SUPPORTED_TYPES.get((Object)value.getClass().getTypeName());
        this.getConcepts(dataType.getVertexProperty(), dataType.getPersistenceValue(value)).forEach(concept -> {
            if (concept != null && concept.isAttribute()) {
                attributes.add(concept.asAttribute());
            }
        });
        return attributes;
    }

    public <T extends SchemaConcept> T getSchemaConcept(Label label) {
        Schema.MetaSchema meta = Schema.MetaSchema.valueOf((Label)label);
        if (meta != null) {
            return this.getSchemaConcept(meta.getId());
        }
        return this.getSchemaConcept(label, Schema.BaseType.SCHEMA_CONCEPT);
    }

    public <T extends Type> T getType(Label label) {
        return (T)((Type)this.getSchemaConcept(label, Schema.BaseType.TYPE));
    }

    public EntityType getEntityType(String label) {
        return (EntityType)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.ENTITY_TYPE);
    }

    public RelationshipType getRelationshipType(String label) {
        return (RelationshipType)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.RELATIONSHIP_TYPE);
    }

    public <V> AttributeType<V> getAttributeType(String label) {
        return (AttributeType)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.ATTRIBUTE_TYPE);
    }

    public Role getRole(String label) {
        return (Role)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.ROLE);
    }

    public Rule getRule(String label) {
        return (Rule)this.getSchemaConcept(Label.of((String)label), Schema.BaseType.RULE);
    }

    public void clearGraph() {
        this.getTinkerPopGraph().traversal().V(new Object[0]).drop().iterate();
    }

    public void closeSession() {
        try {
            this.txCache().closeTx(ErrorMessage.SESSION_CLOSED.getMessage(new Object[]{this.keyspace()}));
            this.getTinkerPopGraph().close();
        }
        catch (Exception e) {
            throw GraknTxOperationException.closingFailed((GraknTx)this, (Exception)e);
        }
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.txCache().writeToGraphCache(this.txType().equals((Object)GraknTxType.READ));
        }
        catch (Throwable throwable) {
            String closeMessage = ErrorMessage.TX_CLOSED_ON_ACTION.getMessage(new Object[]{"closed", this.keyspace()});
            this.closeTransaction(closeMessage);
            throw throwable;
        }
        String closeMessage = ErrorMessage.TX_CLOSED_ON_ACTION.getMessage(new Object[]{"closed", this.keyspace()});
        this.closeTransaction(closeMessage);
    }

    public void commit() throws InvalidKBException {
        if (this.isClosed()) {
            return;
        }
        String closeMessage = ErrorMessage.TX_CLOSED_ON_ACTION.getMessage(new Object[]{"committed", this.keyspace()});
        try {
            this.validateGraph();
            this.commitTransactionInternal();
            this.txCache().writeToGraphCache(true);
        }
        finally {
            this.closeTransaction(closeMessage);
        }
    }

    public Optional<CommitLog> commitAndGetLogs() throws InvalidKBException {
        Optional<CommitLog> optional;
        if (this.isClosed()) {
            return Optional.empty();
        }
        try {
            optional = this.commitWithLogs();
        }
        catch (Throwable throwable) {
            String closeMessage = ErrorMessage.TX_CLOSED_ON_ACTION.getMessage(new Object[]{"committed", this.keyspace()});
            this.closeTransaction(closeMessage);
            throw throwable;
        }
        String closeMessage = ErrorMessage.TX_CLOSED_ON_ACTION.getMessage(new Object[]{"committed", this.keyspace()});
        this.closeTransaction(closeMessage);
        return optional;
    }

    private void closeTransaction(String closedReason) {
        try {
            this.graph.tx().close();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            this.txCache().closeTx(closedReason);
            this.ruleCache().closeTx();
        }
    }

    private Optional<CommitLog> commitWithLogs() throws InvalidKBException {
        this.validateGraph();
        Map<ConceptId, Long> newInstances = this.txCache().getShardingCount();
        Map<String, ConceptId> newAttributes = this.txCache().getNewAttributes();
        boolean logsExist = !newInstances.isEmpty() || !newAttributes.isEmpty();
        this.commitTransactionInternal();
        this.txCache().writeToGraphCache(true);
        if (logsExist) {
            Map<String, Set> attributes = newAttributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singleton(e.getValue())));
            return Optional.of(CommitLog.create((Keyspace)this.keyspace(), newInstances, attributes));
        }
        return Optional.empty();
    }

    void commitTransactionInternal() {
        try {
            this.LOG.trace("Graph is valid. Committing graph . . . ");
            this.getTinkerPopGraph().tx().commit();
            this.LOG.trace("Graph committed.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void validateGraph() throws InvalidKBException {
        List<String> errors;
        Validator validator = new Validator(this);
        if (!validator.validate() && !(errors = validator.getErrorsFound()).isEmpty()) {
            throw InvalidKBException.validationErrors(errors);
        }
    }

    public boolean isValidElement(Element element) {
        return element != null;
    }

    private <X extends ConceptImpl> Set<X> getDuplicates(X mainConcept, Set<ConceptId> conceptIds) {
        Set duplicated = conceptIds.stream().map(this::getConcept).filter(Objects::nonNull).collect(Collectors.toSet());
        duplicated.remove(mainConcept);
        return duplicated;
    }

    public boolean duplicateResourcesExist(String index, Set<ConceptId> resourceVertexIds) {
        Optional<AttributeImpl> mainResource = this.getConcept(Schema.VertexProperty.INDEX, index);
        return mainResource.filter(attribute -> this.getDuplicates(attribute, resourceVertexIds).size() > 0).isPresent();
    }

    public boolean fixDuplicateResources(String index, Set<ConceptId> resourceVertexIds) {
        Optional mainResourceOp = this.getConcept(Schema.VertexProperty.INDEX, index);
        if (!mainResourceOp.isPresent()) {
            this.LOG.debug(String.format("Could not post process concept with index {%s} due to not finding the concept", index));
            return false;
        }
        AttributeImpl mainResource = (AttributeImpl)mainResourceOp.get();
        Set<AttributeImpl> duplicates = this.getDuplicates(mainResource, resourceVertexIds);
        if (duplicates.size() > 0) {
            for (Attribute attribute : duplicates) {
                Stream otherRelations = attribute.relationships(new Role[0]);
                otherRelations.forEach(otherRelation -> this.copyRelation(mainResource, otherAttribute, (Relationship)otherRelation));
                AttributeImpl.from(attribute).deleteNode();
            }
            String newIndex = mainResource.getIndex();
            ((Vertex)mainResource.vertex().element()).property(Schema.VertexProperty.INDEX.name(), (Object)newIndex);
            return true;
        }
        return false;
    }

    private void copyRelation(Attribute main, Attribute other, Relationship otherRelationship) {
        Optional<RelationshipReified> reifiedRelation = ((RelationshipImpl)otherRelationship).reified();
        if (reifiedRelation.isPresent()) {
            this.copyRelationshipReified(main, other, otherRelationship);
        } else {
            this.copyRelationshipEdge(main, other, (RelationshipEdge)RelationshipImpl.from(otherRelationship).structure());
        }
    }

    private void copyRelationshipReified(Attribute main, Attribute other, Relationship otherRelationship) {
        otherRelationship.rolePlayersMap().forEach((role, instances) -> {
            Optional<RelationshipReified> relationReified = RelationshipImpl.from(otherRelationship).reified();
            if (instances.contains(other) && relationReified.isPresent()) {
                relationReified.get().putRolePlayerEdge((Role)role, (Thing)main);
            }
        });
    }

    private void copyRelationshipEdge(Attribute main, Attribute other, RelationshipEdge relationEdge) {
        ConceptVertex newValue;
        ConceptVertex newOwner;
        if (relationEdge.owner().equals(other)) {
            newOwner = ConceptVertex.from((Concept)main);
            newValue = ConceptVertex.from((Concept)relationEdge.value());
        } else {
            newOwner = ConceptVertex.from((Concept)relationEdge.owner());
            newValue = ConceptVertex.from((Concept)main);
        }
        EdgeElement edge = newOwner.vertex().putEdge(newValue.vertex(), Schema.EdgeLabel.ATTRIBUTE);
        this.factory().buildRelation(edge, relationEdge.type(), relationEdge.ownerRole(), relationEdge.valueRole());
    }

    public void shard(ConceptId conceptId) {
        ConceptImpl type = (ConceptImpl)this.getConcept(conceptId);
        if (type == null) {
            this.LOG.warn("Cannot shard concept [" + conceptId + "] due to it not existing in the graph");
        } else {
            type.createShard();
        }
    }

    public long getShardCount(Type concept) {
        return TypeImpl.from(concept).shardCount();
    }

    public final QueryExecutor queryExecutor() {
        if (queryExecutorFactory == null) {
            throw new RuntimeException(ErrorMessage.CANNOT_FIND_CLASS.getMessage(new Object[]{"query builder", QUERY_BUILDER_CLASS_NAME}));
        }
        try {
            return (QueryExecutor)queryExecutorFactory.invoke(null, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static Constructor<?> getQueryBuilderConstructor() {
        try {
            return Class.forName(QUERY_BUILDER_CLASS_NAME).getConstructor(GraknTx.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @Nullable
    private static Method getQueryExecutorFactory() {
        try {
            return Class.forName(QUERY_EXECUTOR_CLASS_NAME).getDeclaredMethod("create", EmbeddedGraknTx.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }
}

