/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.cache;

import ai.grakn.GraknTxType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.kb.internal.cache.CacheOwner;
import ai.grakn.kb.internal.cache.GlobalCache;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.structure.Casting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TxCache {
    private final GlobalCache globalCache;
    private final Map<ConceptId, Concept> conceptCache = new HashMap<ConceptId, Concept>();
    private final Map<Label, SchemaConcept> schemaConceptCache = new HashMap<Label, SchemaConcept>();
    private final Map<Label, LabelId> labelCache = new HashMap<Label, LabelId>();
    private final Set<Relationship> newRelationships = new HashSet<Relationship>();
    private final Set<Thing> modifiedThings = new HashSet<Thing>();
    private final Set<Role> modifiedRoles = new HashSet<Role>();
    private final Set<Casting> modifiedCastings = new HashSet<Casting>();
    private final Set<RelationshipType> modifiedRelationshipTypes = new HashSet<RelationshipType>();
    private final Set<Rule> modifiedRules = new HashSet<Rule>();
    private final Map<ConceptId, Long> shardingCount = new HashMap<ConceptId, Long>();
    private Map<String, ConceptId> newAttributes = new HashMap<String, ConceptId>();
    private boolean isTxOpen = false;
    private boolean writeOccurred = false;
    private GraknTxType txType;
    private String closedReason = null;

    public TxCache(GlobalCache globalCache) {
        this.globalCache = globalCache;
    }

    public void writeToGraphCache(boolean isSafe) {
        if (isSafe || !this.writeOccurred) {
            this.globalCache.readTxCache(this);
        }
    }

    public void writeOccurred() {
        this.writeOccurred = true;
    }

    public boolean schemaNotCached() {
        return this.labelCache.isEmpty();
    }

    public void refreshSchemaCache() {
        this.globalCache.populateSchemaTxCache(this);
    }

    public void trackForValidation(Concept concept) {
        if (concept.isThing()) {
            this.modifiedThings.add(concept.asThing());
        } else if (concept.isRole()) {
            this.modifiedRoles.add(concept.asRole());
        } else if (concept.isRelationshipType()) {
            this.modifiedRelationshipTypes.add(concept.asRelationshipType());
        } else if (concept.isRule()) {
            this.modifiedRules.add(concept.asRule());
        }
    }

    public void trackForValidation(Casting casting) {
        this.modifiedCastings.add(casting);
    }

    public void removeFromValidation(Type type) {
        if (type.isRelationshipType()) {
            this.modifiedRelationshipTypes.remove(type.asRelationshipType());
        }
    }

    public Map<ConceptId, Long> getShardingCount() {
        return this.shardingCount;
    }

    Map<Label, SchemaConcept> getSchemaConceptCache() {
        return this.schemaConceptCache;
    }

    Map<Label, LabelId> getLabelCache() {
        return this.labelCache;
    }

    Map<ConceptId, Concept> getConceptCache() {
        return this.conceptCache;
    }

    public void remove(Concept concept) {
        this.modifiedThings.remove(concept);
        this.modifiedRoles.remove(concept);
        this.modifiedRelationshipTypes.remove(concept);
        this.modifiedRules.remove(concept);
        if (concept.isAttribute()) {
            this.newAttributes.remove(AttributeImpl.from(concept.asAttribute()).getIndex());
        }
        if (concept.isRelationship()) {
            this.newRelationships.remove(concept.asRelationship());
        }
        this.conceptCache.remove(concept.id());
        if (concept.isSchemaConcept()) {
            Label label = concept.asSchemaConcept().label();
            this.schemaConceptCache.remove(label);
            this.labelCache.remove(label);
        }
    }

    public void remove(Casting casting) {
        this.modifiedCastings.remove(casting);
    }

    public void cacheConcept(Concept concept) {
        this.conceptCache.put(concept.id(), concept);
        if (concept.isSchemaConcept()) {
            SchemaConcept schemaConcept = concept.asSchemaConcept();
            this.schemaConceptCache.put(schemaConcept.label(), schemaConcept);
            this.labelCache.put(schemaConcept.label(), schemaConcept.labelId());
        }
    }

    void cacheLabel(Label label, LabelId id) {
        this.labelCache.put(label, id);
    }

    public boolean isConceptCached(ConceptId id) {
        return this.conceptCache.containsKey(id);
    }

    public boolean isTypeCached(Label label) {
        return this.schemaConceptCache.containsKey(label);
    }

    public boolean isLabelCached(Label label) {
        return this.labelCache.containsKey(label);
    }

    public <X extends Concept> X getCachedConcept(ConceptId id) {
        return (X)this.conceptCache.get(id);
    }

    public <X extends SchemaConcept> X getCachedSchemaConcept(Label label) {
        return (X)this.schemaConceptCache.get(label);
    }

    public LabelId convertLabelToId(Label label) {
        return this.labelCache.get(label);
    }

    public void addedInstance(ConceptId conceptId) {
        this.shardingCount.compute(conceptId, (key, value) -> value == null ? 1L : value + 1L);
        this.cleanupShardingCount(conceptId);
    }

    public void removedInstance(ConceptId conceptId) {
        this.shardingCount.compute(conceptId, (key, value) -> value == null ? -1L : value - 1L);
        this.cleanupShardingCount(conceptId);
    }

    private void cleanupShardingCount(ConceptId conceptId) {
        if (this.shardingCount.get(conceptId) == 0L) {
            this.shardingCount.remove(conceptId);
        }
    }

    public void addNewAttribute(String index, ConceptId conceptId) {
        this.newAttributes.put(index, conceptId);
    }

    public Map<String, ConceptId> getNewAttributes() {
        return this.newAttributes;
    }

    public Set<Thing> getModifiedThings() {
        return this.modifiedThings;
    }

    public Set<Role> getModifiedRoles() {
        return this.modifiedRoles;
    }

    public Set<RelationshipType> getModifiedRelationshipTypes() {
        return this.modifiedRelationshipTypes;
    }

    public Set<Rule> getModifiedRules() {
        return this.modifiedRules;
    }

    public Set<Casting> getModifiedCastings() {
        return this.modifiedCastings;
    }

    public void addNewRelationship(Relationship relationship) {
        this.newRelationships.add(relationship);
    }

    public Set<Relationship> getNewRelationships() {
        return this.newRelationships;
    }

    public void closeTx(String closedReason) {
        this.isTxOpen = false;
        this.closedReason = closedReason;
        this.conceptCache.values().forEach(concept -> CacheOwner.from(concept).txCacheClear());
        this.modifiedThings.clear();
        this.modifiedRoles.clear();
        this.modifiedRelationshipTypes.clear();
        this.modifiedRules.clear();
        this.modifiedCastings.clear();
        this.newAttributes.clear();
        this.newRelationships.clear();
        this.shardingCount.clear();
        this.conceptCache.clear();
        this.schemaConceptCache.clear();
        this.labelCache.clear();
    }

    public void openTx(GraknTxType txType) {
        this.isTxOpen = true;
        this.txType = txType;
        this.closedReason = null;
    }

    public boolean isTxOpen() {
        return this.isTxOpen;
    }

    public GraknTxType txType() {
        return this.txType;
    }

    public String getClosedReason() {
        return this.closedReason;
    }
}

