/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.cache;

import ai.grakn.concept.Label;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TxRuleCache {
    private final Map<SchemaConcept, Set<Rule>> ruleMap = new HashMap<SchemaConcept, Set<Rule>>();
    private final Map<Rule, Object> ruleConversionMap = new HashMap<Rule, Object>();
    private final EmbeddedGraknTx tx;

    public TxRuleCache(EmbeddedGraknTx tx) {
        this.tx = tx;
    }

    public Stream<Rule> getRules() {
        Rule metaRule = this.tx.getMetaRule();
        return metaRule.subs().filter(sub -> !sub.equals(metaRule));
    }

    public Set<Rule> updateRules(SchemaConcept type, Rule rule) {
        Set<Rule> match = this.ruleMap.get(type);
        if (match == null) {
            HashSet rules = Sets.newHashSet((Object[])new Rule[]{rule});
            this.getTypes(type, false).stream().flatMap(SchemaConcept::thenRules).forEach(rules::add);
            this.ruleMap.put(type, rules);
            return rules;
        }
        match.add(rule);
        return match;
    }

    public Stream<Rule> getRulesWithType(SchemaConcept type) {
        return this.getRulesWithType(type, false);
    }

    private Set<SchemaConcept> getTypes(SchemaConcept type, boolean direct) {
        HashSet types;
        HashSet hashSet = types = direct ? Sets.newHashSet((Object[])new SchemaConcept[]{type}) : type.subs().collect(Collectors.toSet());
        if (type.isImplicit().booleanValue()) {
            types.add(this.tx.getSchemaConcept(Schema.ImplicitType.explicitLabel((Label)type.label())));
        }
        return types;
    }

    public Stream<Rule> getRulesWithType(SchemaConcept type, boolean direct) {
        if (type == null) {
            return this.getRules();
        }
        Set<Rule> match = this.ruleMap.get(type);
        if (match != null) {
            return match.stream();
        }
        HashSet rules = new HashSet();
        this.ruleMap.put(type, rules);
        return this.getTypes(type, direct).stream().flatMap(SchemaConcept::thenRules).peek(rules::add);
    }

    public <T> T getRule(Rule rule, Supplier<T> converter) {
        Object match = this.ruleConversionMap.get(rule);
        if (match != null) {
            return (T)match;
        }
        T newMatch = converter.get();
        this.ruleConversionMap.put(rule, newMatch);
        return newMatch;
    }

    public void closeTx() {
        this.ruleMap.clear();
        this.ruleConversionMap.clear();
    }
}

