/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class AttributeTypeImpl<D>
extends TypeImpl<AttributeType<D>, Attribute<D>>
implements AttributeType<D> {
    private AttributeTypeImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    private AttributeTypeImpl(VertexElement vertexElement, AttributeType<D> type, AttributeType.DataType<D> dataType) {
        super(vertexElement, type);
        this.vertex().propertyImmutable(Schema.VertexProperty.DATA_TYPE, dataType, this.dataType(), AttributeType.DataType::getName);
    }

    public static <D> AttributeTypeImpl<D> get(VertexElement vertexElement) {
        return new AttributeTypeImpl<D>(vertexElement);
    }

    public static <D> AttributeTypeImpl<D> create(VertexElement vertexElement, AttributeType<D> type, AttributeType.DataType<D> dataType) {
        return new AttributeTypeImpl<D>(vertexElement, type, dataType);
    }

    @Override
    public AttributeType<D> sup(AttributeType<D> superType) {
        ((AttributeTypeImpl)superType).sups().forEach(st -> this.checkInstancesMatchRegex(st.regex()));
        return super.sup(superType);
    }

    public AttributeType<D> regex(String regex) {
        if (this.dataType() == null || !this.dataType().equals((Object)AttributeType.DataType.STRING)) {
            throw GraknTxOperationException.cannotSetRegex((AttributeType)this);
        }
        this.checkInstancesMatchRegex(regex);
        return (AttributeType)this.property(Schema.VertexProperty.REGEX, regex);
    }

    private void checkInstancesMatchRegex(@Nullable String regex) {
        if (regex != null) {
            Pattern pattern = Pattern.compile(regex);
            this.instances().forEach(resource -> {
                String value = (String)resource.value();
                Matcher matcher = pattern.matcher(value);
                if (!matcher.matches()) {
                    throw GraknTxOperationException.regexFailure((AttributeType)this, (String)value, (String)regex);
                }
            });
        }
    }

    public Attribute<D> create(D value) {
        return this.putAttribute(value, false);
    }

    public Attribute<D> putAttributeInferred(D value) {
        return this.putAttribute(value, true);
    }

    private Attribute<D> putAttribute(D value, boolean isInferred) {
        Objects.requireNonNull(value);
        BiFunction<VertexElement, AttributeType, Attribute> instanceBuilder = (vertex, type) -> {
            if (this.dataType().equals((Object)AttributeType.DataType.STRING)) {
                this.checkConformsToRegexes(value);
            }
            return this.vertex().tx().factory().buildAttribute((VertexElement)vertex, type, value);
        };
        return this.putInstance(Schema.BaseType.ATTRIBUTE, () -> this.attribute(value), instanceBuilder, isInferred);
    }

    private void checkConformsToRegexes(D value) {
        this.sups().forEach(sup -> {
            String regex = sup.regex();
            if (regex != null && !Pattern.matches(regex, (String)value)) {
                throw GraknTxOperationException.regexFailure((AttributeType)this, (String)((String)value), (String)regex);
            }
        });
    }

    public Attribute<D> attribute(D value) {
        String index = Schema.generateAttributeIndex((Label)this.label(), (String)value.toString());
        return this.vertex().tx().getConcept(Schema.VertexProperty.INDEX, index).orElse(null);
    }

    public AttributeType.DataType<D> dataType() {
        return (AttributeType.DataType)AttributeType.DataType.SUPPORTED_TYPES.get(this.vertex().property(Schema.VertexProperty.DATA_TYPE));
    }

    public String regex() {
        return (String)this.vertex().property(Schema.VertexProperty.REGEX);
    }

    public static AttributeTypeImpl from(AttributeType attributeType) {
        return (AttributeTypeImpl)attributeType;
    }
}

