/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknComputer;
import ai.grakn.GraknConfigKey;
import ai.grakn.GraknSession;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.engine.GraknConfig;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.factory.GraknTxFactoryBuilder;
import ai.grakn.factory.TxFactory;
import ai.grakn.factory.TxFactoryBuilder;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.kb.internal.computer.GraknComputerImpl;
import ai.grakn.util.ErrorMessage;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedGraknSession
implements GraknSession {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedGraknSession.class);
    private final Keyspace keyspace;
    private final GraknConfig config;
    private final TxFactory<?> txFactory;
    private final TxFactory<?> computerTxFactory;
    private EmbeddedGraknTx<?> tx = null;
    private EmbeddedGraknTx<?> txBatch = null;
    private static final Map<String, EmbeddedGraknSession> inMemorySessions = new ConcurrentHashMap<String, EmbeddedGraknSession>();

    EmbeddedGraknSession(Keyspace keyspace, @Nullable GraknConfig config, TxFactoryBuilder txFactoryBuilder) {
        Objects.requireNonNull(keyspace);
        this.keyspace = keyspace;
        this.config = config;
        this.txFactory = txFactoryBuilder.getFactory(this, false);
        this.computerTxFactory = txFactoryBuilder.getFactory(this, true);
    }

    public static EmbeddedGraknSession createEngineSession(Keyspace keyspace, GraknConfig config, TxFactoryBuilder txFactoryBuilder) {
        return new EmbeddedGraknSession(keyspace, config, txFactoryBuilder);
    }

    public static EmbeddedGraknSession createEngineSession(Keyspace keyspace, GraknConfig config) {
        return new EmbeddedGraknSession(keyspace, config, GraknTxFactoryBuilder.getInstance());
    }

    public static EmbeddedGraknSession createEngineSession(Keyspace keyspace) {
        return new EmbeddedGraknSession(keyspace, GraknConfig.create(), GraknTxFactoryBuilder.getInstance());
    }

    public static EmbeddedGraknSession inMemory(Keyspace keyspace) {
        return inMemorySessions.computeIfAbsent(keyspace.getValue(), k -> EmbeddedGraknSession.createEngineSession(keyspace, EmbeddedGraknSession.getTxInMemoryConfig()));
    }

    public static EmbeddedGraknSession inMemory(String keyspace) {
        return EmbeddedGraknSession.inMemory(Keyspace.of((String)keyspace));
    }

    private static GraknConfig getTxInMemoryConfig() {
        GraknConfig config = GraknConfig.empty();
        config.setConfigProperty(GraknConfigKey.SHARDING_THRESHOLD, (Object)100000L);
        config.setConfigProperty(GraknConfigKey.SESSION_CACHE_TIMEOUT_MS, (Object)30000);
        config.setConfigProperty(GraknConfigKey.KB_MODE, (Object)"in-memory");
        config.setConfigProperty(GraknConfigKey.KB_ANALYTICS, (Object)"in-memory");
        return config;
    }

    public EmbeddedGraknTx transaction(GraknTxType transactionType) {
        switch (transactionType) {
            case READ: 
            case WRITE: {
                this.tx = this.txFactory.open(transactionType);
                return this.tx;
            }
            case BATCH: {
                this.txBatch = this.txFactory.open(transactionType);
                return this.txBatch;
            }
        }
        throw GraknTxOperationException.transactionInvalid((Object)transactionType);
    }

    @CheckReturnValue
    public GraknComputer getGraphComputer() {
        Object graph = this.computerTxFactory.getTinkerPopGraph(false);
        return new GraknComputerImpl((Graph)graph);
    }

    public void close() throws GraknTxOperationException {
        int openTransactions = this.openTransactions(this.tx) + this.openTransactions(this.txBatch);
        if (openTransactions > 0) {
            LOG.warn(ErrorMessage.TXS_OPEN.getMessage(new Object[]{this.keyspace, openTransactions}));
        }
        if (this.tx != null) {
            this.tx.closeSession();
        }
        if (this.txBatch != null) {
            this.txBatch.closeSession();
        }
    }

    public Keyspace keyspace() {
        return this.keyspace;
    }

    public GraknConfig config() {
        return this.config;
    }

    private int openTransactions(EmbeddedGraknTx<?> graph) {
        if (graph == null) {
            return 0;
        }
        return graph.numOpenTx();
    }
}

