/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknTxType;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.factory.EmbeddedGraknSession;
import ai.grakn.factory.TxFactory;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.meta.When;
import org.apache.tinkerpop.gremlin.structure.Graph;

public abstract class TxFactoryAbstract<Tx extends EmbeddedGraknTx<G>, G extends Graph>
implements TxFactory<G> {
    private final EmbeddedGraknSession session;
    protected final GraphWithTx batchTinkerPopGraphWithTx = new GraphWithTx(true);
    protected final GraphWithTx tinkerPopGraphWithTx = new GraphWithTx(false);

    protected TxFactoryAbstract(EmbeddedGraknSession session) {
        this.session = session;
    }

    protected abstract Tx buildGraknTxFromTinkerGraph(G var1);

    protected abstract G buildTinkerPopGraph(boolean var1);

    public final synchronized Tx open(GraknTxType txType) {
        if (GraknTxType.BATCH.equals((Object)txType)) {
            this.tinkerPopGraphWithTx.checkTxIsOpen();
            return this.batchTinkerPopGraphWithTx.openTx(txType);
        }
        this.batchTinkerPopGraphWithTx.checkTxIsOpen();
        return this.tinkerPopGraphWithTx.openTx(txType);
    }

    @Override
    public final synchronized G getTinkerPopGraph(boolean batchLoading) {
        if (batchLoading) {
            return this.batchTinkerPopGraphWithTx.getTinkerPopGraph();
        }
        return this.tinkerPopGraphWithTx.getTinkerPopGraph();
    }

    @CheckReturnValue(when=When.NEVER)
    protected abstract G getGraphWithNewTransaction(G var1, boolean var2);

    public final EmbeddedGraknSession session() {
        return this.session;
    }

    class GraphWithTx {
        @Nullable
        private Tx graknTx = null;
        private G graph = null;
        private final boolean batchLoading;

        public GraphWithTx(boolean batchLoading) {
            this.batchLoading = batchLoading;
        }

        public Tx openTx(GraknTxType txType) {
            this.initialiseGraknTx();
            ((EmbeddedGraknTx)this.graknTx).openTransaction(txType);
            return this.graknTx;
        }

        private void initialiseGraknTx() {
            if (this.graknTx != null && !((EmbeddedGraknTx)this.graknTx).isClosed()) {
                throw GraknTxOperationException.transactionOpen(this.graknTx);
            }
            if (this.graknTx == null || ((EmbeddedGraknTx)this.graknTx).isTinkerPopGraphClosed()) {
                this.graknTx = TxFactoryAbstract.this.buildGraknTxFromTinkerGraph(this.getTinkerPopGraph());
            }
        }

        protected G getTinkerPopGraph() {
            this.graph = this.graph == null ? TxFactoryAbstract.this.buildTinkerPopGraph(this.batchLoading) : TxFactoryAbstract.this.getGraphWithNewTransaction(this.graph, this.batchLoading);
            return this.graph;
        }

        public void checkTxIsOpen() {
            if (this.graknTx != null && !((EmbeddedGraknTx)this.graknTx).isClosed()) {
                throw GraknTxOperationException.transactionOpen(this.graknTx);
            }
        }
    }
}

