/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.factory.EmbeddedGraknSession;
import ai.grakn.factory.GraknTxFactoryBuilder;
import ai.grakn.factory.TxFactory;
import ai.grakn.util.ErrorMessage;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TxFactoryBuilder {
    public static final String IN_MEMORY = "in-memory";
    private static final Logger LOG = LoggerFactory.getLogger(GraknTxFactoryBuilder.class);

    public abstract TxFactory<?> getFactory(EmbeddedGraknSession var1, boolean var2);

    protected static final synchronized TxFactory<?> newFactory(String factoryType, EmbeddedGraknSession session) {
        TxFactory txFactory;
        try {
            txFactory = (TxFactory)Class.forName(factoryType).getDeclaredConstructor(EmbeddedGraknSession.class).newInstance(session);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(ErrorMessage.INVALID_FACTORY.getMessage(new Object[]{factoryType}), e);
        }
        LOG.trace("New factory created " + txFactory);
        return txFactory;
    }
}

