/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.RelationshipStructure;
import ai.grakn.kb.internal.concept.ThingImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class RelationshipReified
extends ThingImpl<Relationship, RelationshipType>
implements RelationshipStructure {
    @Nullable
    private RelationshipImpl owner;

    private RelationshipReified(VertexElement vertexElement) {
        super(vertexElement);
    }

    private RelationshipReified(VertexElement vertexElement, RelationshipType type) {
        super(vertexElement, type);
    }

    public static RelationshipReified get(VertexElement vertexElement) {
        return new RelationshipReified(vertexElement);
    }

    public static RelationshipReified create(VertexElement vertexElement, RelationshipType type) {
        return new RelationshipReified(vertexElement, type);
    }

    @Override
    public Map<Role, Set<Thing>> allRolePlayers() {
        HashMap<Role, Set<Thing>> roleMap = new HashMap<Role, Set<Thing>>();
        ((RelationshipType)this.type()).roles().forEach(roleType -> {
            Set cfr_ignored_0 = roleMap.put((Role)roleType, new HashSet());
        });
        this.castingsRelation(new Role[0]).forEach(rp -> roleMap.computeIfAbsent(rp.getRole(), k -> new HashSet()).add(rp.getRolePlayer()));
        return roleMap;
    }

    @Override
    public Stream<Thing> rolePlayers(Role ... roles) {
        return this.castingsRelation(roles).map(Casting::getRolePlayer).distinct();
    }

    void removeRolePlayer(Role role, Thing thing) {
        this.castingsRelation(new Role[0]).filter(casting -> casting.getRole().equals(role) && casting.getRolePlayer().equals(thing)).findAny().ifPresent(casting -> {
            casting.delete();
            this.vertex().tx().txCache().remove((Casting)casting);
        });
    }

    public void addRolePlayer(Role role, Thing thing) {
        Objects.requireNonNull(role);
        Objects.requireNonNull(thing);
        if (Schema.MetaSchema.isMetaLabel((Label)role.label())) {
            throw GraknTxOperationException.metaTypeImmutable((Label)role.label());
        }
        this.putRolePlayerEdge(role, thing);
    }

    public void putRolePlayerEdge(Role role, Thing toThing) {
        GraphTraversal traversal = this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.id().getValue()).outE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID.name(), (Object)((RelationshipType)this.type()).labelId().getValue()).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), (Object)role.labelId().getValue()).as("edge", new String[0]).inV().has(Schema.VertexProperty.ID.name(), (Object)toThing.id()).select("edge");
        if (traversal.hasNext()) {
            return;
        }
        EdgeElement edge = this.addEdge(ConceptVertex.from((Concept)toThing), Schema.EdgeLabel.ROLE_PLAYER);
        edge.property(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID, ((RelationshipType)this.type()).labelId().getValue());
        edge.property(Schema.EdgeProperty.ROLE_LABEL_ID, role.labelId().getValue());
        Casting casting = Casting.create(edge, this.owner, role, toThing);
        this.vertex().tx().txCache().trackForValidation(casting);
    }

    public Stream<Casting> castingsRelation(Role ... roles) {
        HashSet<Role> roleSet = new HashSet<Role>(Arrays.asList(roles));
        if (roleSet.isEmpty()) {
            return this.vertex().getEdgesOfType(Direction.OUT, Schema.EdgeLabel.ROLE_PLAYER).map(edge -> Casting.withRelationship(edge, this.owner));
        }
        Set roleTypesIds = roleSet.stream().map(r -> r.labelId().getValue()).collect(Collectors.toSet());
        return this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.id().getValue()).outE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID.name(), (Object)((RelationshipType)this.type()).labelId().getValue()).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), P.within(roleTypesIds)).toStream().map(edge -> this.vertex().tx().factory().buildEdgeElement((Edge)edge)).map(edge -> Casting.withRelationship(edge, this.owner));
    }

    @Override
    public String innerToString() {
        StringBuilder description = new StringBuilder();
        description.append("ID [").append(this.id()).append("] Type [").append(((RelationshipType)this.type()).label()).append("] Roles and Role Players: \n");
        for (Map.Entry<Role, Set<Thing>> entry : this.allRolePlayers().entrySet()) {
            if (entry.getValue().isEmpty()) {
                description.append("    Role [").append(entry.getKey().label()).append("] not played by any instance \n");
                continue;
            }
            StringBuilder instancesString = new StringBuilder();
            for (Thing thing : entry.getValue()) {
                instancesString.append(thing.id()).append(",");
            }
            description.append("    Role [").append(entry.getKey().label()).append("] played by [").append(instancesString.toString()).append("] \n");
        }
        return description.toString();
    }

    public void owner(RelationshipImpl relationship) {
        this.owner = relationship;
    }

    @Override
    public RelationshipReified reify() {
        return this;
    }

    @Override
    public boolean isReified() {
        return true;
    }
}

