/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.RoleImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class RelationshipTypeImpl
extends TypeImpl<RelationshipType, Relationship>
implements RelationshipType {
    private final Cache<Set<Role>> cachedRelates = Cache.createSessionCache(this, Cacheable.set(), () -> this.neighbours(Direction.OUT, Schema.EdgeLabel.RELATES).collect(Collectors.toSet()));

    private RelationshipTypeImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    private RelationshipTypeImpl(VertexElement vertexElement, RelationshipType type) {
        super(vertexElement, type);
    }

    public static RelationshipTypeImpl get(VertexElement vertexElement) {
        return new RelationshipTypeImpl(vertexElement);
    }

    public static RelationshipTypeImpl create(VertexElement vertexElement, RelationshipType type) {
        RelationshipTypeImpl relationType = new RelationshipTypeImpl(vertexElement, type);
        vertexElement.tx().txCache().trackForValidation(relationType);
        return relationType;
    }

    public Relationship create() {
        return this.addRelationship(false);
    }

    public Relationship addRelationshipInferred() {
        return this.addRelationship(true);
    }

    public Relationship addRelationship(boolean isInferred) {
        Relationship relationship = this.addInstance(Schema.BaseType.RELATIONSHIP, (vertex, type) -> this.vertex().tx().factory().buildRelation((VertexElement)vertex, (RelationshipType)type), isInferred, true);
        this.vertex().tx().txCache().addNewRelationship(relationship);
        return relationship;
    }

    public Stream<Role> roles() {
        return this.cachedRelates.get().stream();
    }

    public RelationshipType relates(Role role) {
        this.checkSchemaMutationAllowed();
        this.putEdge(ConceptVertex.from((Concept)role), Schema.EdgeLabel.RELATES);
        this.cachedRelates.ifPresent(set -> set.add(role));
        ((RoleImpl)role).addCachedRelationType(this);
        return this;
    }

    public RelationshipType unrelate(Role role) {
        this.checkSchemaMutationAllowed();
        this.deleteEdge(Direction.OUT, Schema.EdgeLabel.RELATES, new Concept[]{role});
        RoleImpl roleTypeImpl = (RoleImpl)role;
        roleTypeImpl.rolePlayers().forEach(rolePlayer -> this.vertex().tx().txCache().trackForValidation((Casting)rolePlayer));
        this.vertex().tx().txCache().trackForValidation(roleTypeImpl);
        this.vertex().tx().txCache().trackForValidation(roleTypeImpl);
        this.cachedRelates.ifPresent(set -> set.remove(role));
        ((RoleImpl)role).deleteCachedRelationType(this);
        return this;
    }

    @Override
    public void delete() {
        this.cachedRelates.get().forEach(r -> {
            RoleImpl role = (RoleImpl)r;
            this.vertex().tx().txCache().trackForValidation(role);
            ((RoleImpl)r).deleteCachedRelationType(this);
        });
        super.delete();
    }

    @Override
    void trackRolePlayers() {
        this.instances().forEach(concept -> {
            RelationshipImpl relation = RelationshipImpl.from(concept);
            if (relation.reified().isPresent()) {
                relation.reified().get().castingsRelation(new Role[0]).forEach(rolePlayer -> this.vertex().tx().txCache().trackForValidation((Casting)rolePlayer));
            }
        });
    }

    @Override
    public Stream<Relationship> instancesDirect() {
        Stream<Relationship> instances = super.instancesDirect();
        if (this.isImplicit().booleanValue()) {
            instances = Stream.concat(instances, this.relationEdges());
        }
        return instances;
    }

    private Stream<Relationship> relationEdges() {
        return this.roles().flatMap(Role::players).flatMap(type -> this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)type.id().getValue()).in(new String[]{Schema.EdgeLabel.SHARD.getLabel()}).in(new String[]{Schema.EdgeLabel.ISA.getLabel()}).outE(new String[]{Schema.EdgeLabel.ATTRIBUTE.getLabel()}).has(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID.name(), (Object)this.labelId().getValue()).toStream().map(edge -> (Relationship)this.vertex().tx().factory().buildConcept((Edge)edge)));
    }

    public static RelationshipTypeImpl from(RelationshipType relationshipType) {
        return (RelationshipTypeImpl)relationshipType;
    }
}

