/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.PropertyNotUniqueException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import scala.tools.scalap.scalax.rules.scalasig.NoSymbol;

public abstract class SchemaConceptImpl<T extends SchemaConcept>
extends ConceptImpl
implements SchemaConcept {
    private final Cache<Label> cachedLabel = Cache.createPersistentCache(this, Cacheable.label(), () -> Label.of((String)((String)this.vertex().property(Schema.VertexProperty.SCHEMA_LABEL))));
    private final Cache<LabelId> cachedLabelId = Cache.createSessionCache(this, Cacheable.labelId(), () -> LabelId.of((Integer)((Integer)this.vertex().property(Schema.VertexProperty.LABEL_ID))));
    private final Cache<T> cachedSuperType = Cache.createSessionCache(this, Cacheable.concept(), () -> this.neighbours(Direction.OUT, Schema.EdgeLabel.SUB).findFirst().orElse(null));
    private final Cache<Set<T>> cachedDirectSubTypes = Cache.createSessionCache(this, Cacheable.set(), () -> this.neighbours(Direction.IN, Schema.EdgeLabel.SUB).collect(Collectors.toSet()));
    private final Cache<Boolean> cachedIsImplicit = Cache.createSessionCache(this, Cacheable.bool(), () -> this.vertex().propertyBoolean(Schema.VertexProperty.IS_IMPLICIT));

    SchemaConceptImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    SchemaConceptImpl(VertexElement vertexElement, T superType) {
        this(vertexElement);
        if (this.sup() == null) {
            this.sup(superType);
        }
    }

    public T label(Label label) {
        try {
            this.vertex().tx().txCache().remove(this);
            this.vertex().propertyUnique(Schema.VertexProperty.SCHEMA_LABEL, label.getValue());
            this.cachedLabel.set(label);
            this.vertex().tx().txCache().cacheConcept(this);
            return (T)((SchemaConcept)this.getThis());
        }
        catch (PropertyNotUniqueException exception) {
            this.vertex().tx().txCache().cacheConcept(this);
            throw GraknTxOperationException.labelTaken((Label)label);
        }
    }

    public LabelId labelId() {
        return this.cachedLabelId.get();
    }

    public Label label() {
        return this.cachedLabel.get();
    }

    public T sup() {
        return (T)((SchemaConcept)this.cachedSuperType.get());
    }

    public Stream<T> sups() {
        HashSet<SchemaConcept> superSet = new HashSet<SchemaConcept>();
        for (SchemaConcept superParent = (SchemaConcept)this.getThis(); superParent != null && !Schema.MetaSchema.THING.getLabel().equals(superParent.label()); superParent = superParent.sup()) {
            superSet.add(superParent);
        }
        return superSet.stream();
    }

    public Boolean isImplicit() {
        return this.cachedIsImplicit.get();
    }

    @Override
    public void delete() {
        if (!this.deletionAllowed()) {
            throw GraknTxOperationException.cannotBeDeleted((SchemaConcept)this);
        }
        SchemaConcept superConcept = (SchemaConcept)this.cachedSuperType.get();
        this.deleteNode();
        super.deleteCachedDirectedSubType((SchemaConcept)this.getThis());
        this.vertex().tx().txCache().remove(this);
        this.txCacheClear();
    }

    boolean deletionAllowed() {
        this.checkSchemaMutationAllowed();
        return !this.neighbours(Direction.IN, Schema.EdgeLabel.SUB).findAny().isPresent();
    }

    public Stream<T> subs() {
        return this.nextSubLevel((SchemaConcept)this.getThis());
    }

    private void addCachedDirectSubType(T newSubType) {
        this.cachedDirectSubTypes.ifPresent(set -> set.add(newSubType));
    }

    private Stream<T> nextSubLevel(T root) {
        return Stream.concat(Stream.of(root), SchemaConceptImpl.from(root).cachedDirectSubTypes.get().stream().flatMap(this::nextSubLevel));
    }

    void checkSchemaMutationAllowed() {
        this.vertex().tx().checkSchemaMutationAllowed();
        if (Schema.MetaSchema.isMetaLabel((Label)this.label())) {
            throw GraknTxOperationException.metaTypeImmutable((Label)this.label());
        }
    }

    private void deleteCachedDirectedSubType(T oldSubType) {
        this.cachedDirectSubTypes.ifPresent(set -> set.remove(oldSubType));
    }

    public T sup(T newSuperType) {
        T oldSuperType = this.sup();
        if (this.changingSuperAllowed(oldSuperType, newSuperType)) {
            this.cachedSuperType.set(newSuperType);
            if (this.superLoops()) {
                this.cachedSuperType.set(oldSuperType);
                throw GraknTxOperationException.loopCreated((SchemaConcept)this, newSuperType);
            }
            this.deleteEdge(Direction.OUT, Schema.EdgeLabel.SUB, new Concept[0]);
            this.putEdge(ConceptVertex.from(newSuperType), Schema.EdgeLabel.SUB);
            if (oldSuperType != null) {
                ((SchemaConceptImpl)oldSuperType).deleteCachedDirectedSubType((SchemaConcept)this.getThis());
            }
            ((SchemaConceptImpl)newSuperType).addCachedDirectSubType((SchemaConcept)this.getThis());
            if (oldSuperType != null) {
                this.trackRolePlayers();
            }
        }
        return (T)((SchemaConcept)this.getThis());
    }

    boolean changingSuperAllowed(T oldSuperType, T newSuperType) {
        this.checkSchemaMutationAllowed();
        return oldSuperType == null || !oldSuperType.equals(newSuperType);
    }

    abstract void trackRolePlayers();

    private boolean superLoops() {
        HashSet<T> foundTypes = new HashSet<T>();
        Object currentSuperType = this.sup();
        while (currentSuperType != null) {
            foundTypes.add(currentSuperType);
            if (!foundTypes.contains(currentSuperType = currentSuperType.sup())) continue;
            return true;
        }
        return false;
    }

    public Stream<Rule> whenRules() {
        return this.neighbours(Direction.IN, Schema.EdgeLabel.HYPOTHESIS);
    }

    public Stream<Rule> thenRules() {
        return this.neighbours(Direction.IN, Schema.EdgeLabel.CONCLUSION);
    }

    @Override
    public String innerToString() {
        String message = super.innerToString();
        message = message + " - Label [" + this.label() + "] - Abstract [" + NoSymbol.isAbstract() + "] ";
        return message;
    }

    public static <X extends SchemaConcept> SchemaConceptImpl<X> from(SchemaConcept schemaConcept) {
        return (SchemaConceptImpl)schemaConcept;
    }
}

