/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.structure;

import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class Shard {
    private final VertexElement vertexElement;

    public Shard(ConceptImpl owner, VertexElement vertexElement) {
        this(vertexElement);
        this.owner(owner);
    }

    public Shard(VertexElement vertexElement) {
        this.vertexElement = vertexElement;
    }

    public VertexElement vertex() {
        return this.vertexElement;
    }

    public String id() {
        return (String)this.vertex().property(Schema.VertexProperty.ID);
    }

    private void owner(ConceptImpl owner) {
        this.vertex().putEdge(owner.vertex(), Schema.EdgeLabel.SHARD);
    }

    public void link(ConceptImpl concept) {
        concept.vertex().addEdge(this.vertex(), Schema.EdgeLabel.ISA);
    }

    public <V extends Thing> Stream<V> links() {
        return this.vertex().getEdgesOfType(Direction.IN, Schema.EdgeLabel.ISA).map(EdgeElement::source).map(vertexElement -> (Thing)this.vertex().tx().factory().buildConcept((VertexElement)vertexElement));
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Shard shard = (Shard)object;
        return this.id().equals(shard.id());
    }
}

