/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.keyspace;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.KeyspaceStore;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.factory.EmbeddedGraknSession;
import ai.grakn.factory.GraknTxFactoryBuilder;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.util.ErrorMessage;
import com.google.common.base.Stopwatch;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyspaceStoreImpl
implements KeyspaceStore {
    private static final Label KEYSPACE_ENTITY = Label.of((String)"keyspace");
    private static final Keyspace SYSTEM_KB_KEYSPACE = Keyspace.of((String)"graknsystem");
    private static final Logger LOG = LoggerFactory.getLogger(KeyspaceStore.class);
    private final Set<Keyspace> existingKeyspaces;
    private final EmbeddedGraknSession systemKeyspaceSession;
    private final GraknConfig config;

    public KeyspaceStoreImpl(GraknConfig config) {
        this.config = config;
        this.systemKeyspaceSession = EmbeddedGraknSession.createEngineSession(SYSTEM_KB_KEYSPACE, config, GraknTxFactoryBuilder.getInstance());
        this.existingKeyspaces = ConcurrentHashMap.newKeySet();
    }

    public void addKeyspace(Keyspace keyspace) {
        if (this.containsKeyspace(keyspace)) {
            return;
        }
        try (EmbeddedGraknTx tx = this.systemKeyspaceSession.transaction(GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)tx.getSchemaConcept(KEYSPACE_RESOURCE);
            if (keyspaceName == null) {
                throw GraknBackendException.initializationException((Keyspace)keyspace);
            }
            Attribute attribute = keyspaceName.create((Object)keyspace.getValue());
            if (attribute.owner() == null) {
                ((EntityType)tx.getSchemaConcept(KEYSPACE_ENTITY)).create().has(attribute);
            }
            tx.commit();
            this.existingKeyspaces.add(keyspace);
        }
        catch (InvalidKBException e) {
            throw new RuntimeException("Could not add keyspace [" + keyspace + "] to system graph", e);
        }
    }

    public boolean containsKeyspace(Keyspace keyspace) {
        if (this.existingKeyspaces.contains(keyspace)) {
            return true;
        }
        try (EmbeddedGraknTx tx = this.systemKeyspaceSession.transaction(GraknTxType.READ);){
            boolean keyspaceExists;
            boolean bl = keyspaceExists = tx.getAttributeType(KEYSPACE_RESOURCE.getValue()).attribute((Object)keyspace) != null;
            if (keyspaceExists) {
                this.existingKeyspaces.add(keyspace);
            }
            boolean bl2 = keyspaceExists;
            return bl2;
        }
    }

    public boolean deleteKeyspace(Keyspace keyspace) {
        if (keyspace.equals(SYSTEM_KB_KEYSPACE)) {
            return false;
        }
        EmbeddedGraknSession session = EmbeddedGraknSession.createEngineSession(keyspace, this.config);
        session.close();
        try (EmbeddedGraknTx tx = session.transaction(GraknTxType.WRITE);){
            tx.closeSession();
            tx.clearGraph();
            tx.txCache().closeTx(ErrorMessage.CLOSED_CLEAR.getMessage(new Object[0]));
        }
        return this.deleteReferenceInSystemKeyspace(keyspace);
    }

    private boolean deleteReferenceInSystemKeyspace(Keyspace keyspace) {
        try (EmbeddedGraknTx tx = this.systemKeyspaceSession.transaction(GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)tx.getSchemaConcept(KEYSPACE_RESOURCE);
            Attribute attribute = keyspaceName.attribute((Object)keyspace.getValue());
            if (attribute == null) {
                boolean bl = false;
                return bl;
            }
            Thing thing = attribute.owner();
            if (thing != null) {
                thing.delete();
            }
            attribute.delete();
            this.existingKeyspaces.remove(keyspace);
            tx.commit();
        }
        return true;
    }

    public Set<Keyspace> keyspaces() {
        try (EmbeddedGraknTx graph = this.systemKeyspaceSession.transaction(GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)graph.getSchemaConcept(KEYSPACE_RESOURCE);
            Set<Keyspace> set = ((EntityType)graph.getSchemaConcept(KEYSPACE_ENTITY)).instances().flatMap(keyspace -> keyspace.attributes(new AttributeType[]{keyspaceName})).map(name -> (String)name.value()).map(Keyspace::of).collect(Collectors.toSet());
            return set;
        }
    }

    public void loadSystemSchema() {
        Stopwatch timer = Stopwatch.createStarted();
        try (EmbeddedGraknTx tx = this.systemKeyspaceSession.transaction(GraknTxType.WRITE);){
            if (tx.getSchemaConcept(KEYSPACE_ENTITY) != null) {
                return;
            }
            LOG.info("Loading schema");
            this.loadSystemSchema((GraknTx)tx);
            tx.commit();
            LOG.info("Loaded system schema to system keyspace. Took: {}", (Object)timer.stop());
        }
        catch (RuntimeException e) {
            LOG.error("Error while loading system schema in {}. The error was: {}", new Object[]{timer.stop(), e.getMessage(), e});
            throw e;
        }
    }

    private void loadSystemSchema(GraknTx tx) {
        AttributeType keyspaceName = tx.putAttributeType("keyspace-name", AttributeType.DataType.STRING);
        tx.putEntityType("keyspace").key(keyspaceName);
    }
}

