/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.kb.internal.concept.RelationshipTypeImpl;
import ai.grakn.kb.internal.concept.RuleImpl;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ValidateGlobalRules {
    private ValidateGlobalRules() {
        throw new UnsupportedOperationException();
    }

    static Set<String> validatePlaysAndRelatesStructure(Casting casting) {
        HashSet<String> errors = new HashSet<String>();
        Thing thing = casting.getRolePlayer();
        Role role = casting.getRole();
        Relationship relationship = casting.getRelationship();
        ValidateGlobalRules.roleNotAllowedToBePlayed(role, thing).ifPresent(errors::add);
        ValidateGlobalRules.roleNotLinkedToRelationShip(role, relationship.type(), relationship).ifPresent(errors::add);
        return errors;
    }

    private static Optional<String> roleNotLinkedToRelationShip(Role role, RelationshipType relationshipType, Relationship relationship) {
        boolean notFound = role.relationships().noneMatch(innerRelationType -> innerRelationType.label().equals(relationshipType.label()));
        if (notFound) {
            return Optional.of(ErrorMessage.VALIDATION_RELATION_CASTING_LOOP_FAIL.getMessage(new Object[]{relationship.id(), role.label(), relationshipType.label()}));
        }
        return Optional.empty();
    }

    private static Optional<String> roleNotAllowedToBePlayed(Role role, Thing thing) {
        boolean satisfiesPlays = false;
        for (TypeImpl currentConcept = (TypeImpl)thing.type(); currentConcept != null; currentConcept = (TypeImpl)currentConcept.sup()) {
            Map<Role, Boolean> plays = currentConcept.directPlays();
            for (Map.Entry<Role, Boolean> playsEntry : plays.entrySet()) {
                Role rolePlayed = playsEntry.getKey();
                Boolean required = playsEntry.getValue();
                if (!rolePlayed.label().equals(role.label())) continue;
                satisfiesPlays = true;
                if (!required.booleanValue() || CommonUtil.containsOnly((Stream)thing.relationships(new Role[]{role}), (long)1L)) continue;
                return Optional.of(ErrorMessage.VALIDATION_REQUIRED_RELATION.getMessage(new Object[]{thing.id(), thing.type().label(), role.label(), thing.relationships(new Role[]{role}).count()}));
            }
        }
        if (satisfiesPlays) {
            return Optional.empty();
        }
        return Optional.of(ErrorMessage.VALIDATION_CASTING.getMessage(new Object[]{thing.type().label(), thing.id(), role.label()}));
    }

    static Optional<String> validateHasSingleIncomingRelatesEdge(Role role) {
        if (!role.relationships().findAny().isPresent()) {
            return Optional.of(ErrorMessage.VALIDATION_ROLE_TYPE_MISSING_RELATION_TYPE.getMessage(new Object[]{role.label()}));
        }
        return Optional.empty();
    }

    static Optional<String> validateHasMinimumRoles(RelationshipType relationshipType) {
        if (relationshipType.isAbstract().booleanValue() || relationshipType.roles().iterator().hasNext()) {
            return Optional.empty();
        }
        return Optional.of(ErrorMessage.VALIDATION_RELATION_TYPE.getMessage(new Object[]{relationshipType.label()}));
    }

    static Set<String> validateRelationTypesToRolesSchema(RelationshipType relationshipType) {
        RelationshipTypeImpl superRelationType = (RelationshipTypeImpl)relationshipType.sup();
        if (Schema.MetaSchema.isMetaLabel((Label)superRelationType.label()) || superRelationType.isAbstract().booleanValue()) {
            return Collections.emptySet();
        }
        HashSet<String> errorMessages = new HashSet<String>();
        Collection superRelates = superRelationType.roles().collect(Collectors.toSet());
        Collection relates = relationshipType.roles().collect(Collectors.toSet());
        Set relatesLabels = relates.stream().map(SchemaConcept::label).collect(Collectors.toSet());
        if (!superRelationType.isAbstract().booleanValue()) {
            HashSet allSuperRolesPlayed = new HashSet();
            superRelationType.sups().forEach(rel -> rel.roles().forEach(roleType -> allSuperRolesPlayed.add(roleType.label())));
            for (Role relate : relates) {
                boolean validRoleTypeFound = SchemaConceptImpl.from((SchemaConcept)relate).sups().anyMatch(superRole -> allSuperRolesPlayed.contains(superRole.label()));
                if (validRoleTypeFound) continue;
                errorMessages.add(ErrorMessage.VALIDATION_RELATION_TYPES_ROLES_SCHEMA.getMessage(new Object[]{relate.label(), relationshipType.label(), "super", "super", superRelationType.label()}));
            }
        }
        for (Role superRelate : superRelates) {
            boolean subRoleNotFoundInRelates = superRelate.subs().noneMatch(sub -> relatesLabels.contains(sub.label()));
            if (!subRoleNotFoundInRelates) continue;
            errorMessages.add(ErrorMessage.VALIDATION_RELATION_TYPES_ROLES_SCHEMA.getMessage(new Object[]{superRelate.label(), superRelationType.label(), "sub", "sub", relationshipType.label()}));
        }
        return errorMessages;
    }

    static Optional<String> validateInstancePlaysAllRequiredRoles(Thing thing) {
        for (TypeImpl currentConcept = (TypeImpl)thing.type(); currentConcept != null; currentConcept = (TypeImpl)currentConcept.sup()) {
            Map<Role, Boolean> plays = currentConcept.directPlays();
            for (Map.Entry<Role, Boolean> playsEntry : plays.entrySet()) {
                if (!playsEntry.getValue().booleanValue()) continue;
                Role role = playsEntry.getKey();
                Stream relationships = thing.relationships(new Role[]{role});
                if (CommonUtil.containsOnly((Stream)relationships, (long)1L)) continue;
                Label resourceTypeLabel = Schema.ImplicitType.explicitLabel((Label)role.label());
                return Optional.of(ErrorMessage.VALIDATION_NOT_EXACTLY_ONE_KEY.getMessage(new Object[]{thing.id(), resourceTypeLabel}));
            }
        }
        return Optional.empty();
    }

    static Set<String> validateRuleIsValidHornClause(GraknTx graph, Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        if (rule.when().admin().isDisjunction()) {
            errors.add(ErrorMessage.VALIDATION_RULE_DISJUNCTION_IN_BODY.getMessage(new Object[]{rule.label()}));
        }
        if (errors.isEmpty()) {
            errors.addAll(ValidateGlobalRules.validateRuleHead(graph, rule));
        }
        return errors;
    }

    private static ReasonerQuery combinedRuleQuery(GraknTx graph, Rule rule) {
        ReasonerQuery bodyQuery = ((Conjunction)rule.when().admin().getDisjunctiveNormalForm().getPatterns().iterator().next()).toReasonerQuery(graph);
        ReasonerQuery headQuery = ((Conjunction)rule.then().admin().getDisjunctiveNormalForm().getPatterns().iterator().next()).toReasonerQuery(graph);
        return headQuery.conjunction(bodyQuery);
    }

    static Set<String> validateRuleOntologically(GraknTx graph, Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        ReasonerQuery combinedQuery = ValidateGlobalRules.combinedRuleQuery(graph, rule);
        errors.addAll(combinedQuery.validateOntologically());
        return errors;
    }

    private static Set<String> validateRuleHead(GraknTx graph, Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        Set headPatterns = rule.then().admin().getDisjunctiveNormalForm().getPatterns();
        if (headPatterns.size() != 1) {
            errors.add(ErrorMessage.VALIDATION_RULE_DISJUNCTION_IN_HEAD.getMessage(new Object[]{rule.label()}));
        } else {
            ReasonerQuery bodyQuery = ((Conjunction)Iterables.getOnlyElement((Iterable)rule.when().admin().getDisjunctiveNormalForm().getPatterns())).toReasonerQuery(graph);
            ReasonerQuery headQuery = ((Conjunction)Iterables.getOnlyElement((Iterable)headPatterns)).toReasonerQuery(graph);
            ReasonerQuery combinedQuery = headQuery.conjunction(bodyQuery);
            Set headAtoms = headQuery.getAtoms();
            combinedQuery.getAtoms().stream().filter(headAtoms::contains).map(at -> at.validateAsRuleHead(rule)).forEach(errors::addAll);
            Set selectableHeadAtoms = headAtoms.stream().filter(Atomic::isAtom).filter(Atomic::isSelectable).collect(Collectors.toSet());
            if (selectableHeadAtoms.size() > 1) {
                errors.add(ErrorMessage.VALIDATION_RULE_HEAD_NON_ATOMIC.getMessage(new Object[]{rule.label()}));
            }
        }
        return errors;
    }

    static Set<String> validateRuleSchemaConceptExist(GraknTx graph, Rule rule) {
        HashSet<String> errors = new HashSet<String>();
        errors.addAll(ValidateGlobalRules.checkRuleSideInvalid(graph, rule, Schema.VertexProperty.RULE_WHEN, rule.when()));
        errors.addAll(ValidateGlobalRules.checkRuleSideInvalid(graph, rule, Schema.VertexProperty.RULE_THEN, rule.then()));
        return errors;
    }

    private static Set<String> checkRuleSideInvalid(GraknTx graph, Rule rule, Schema.VertexProperty side, Pattern pattern) {
        HashSet<String> errors = new HashSet<String>();
        pattern.admin().varPatterns().stream().flatMap(v -> v.innerVarPatterns().stream()).flatMap(v -> v.getTypeLabels().stream()).forEach(typeLabel -> {
            SchemaConcept schemaConcept = graph.getSchemaConcept(typeLabel);
            if (schemaConcept == null) {
                errors.add(ErrorMessage.VALIDATION_RULE_MISSING_ELEMENTS.getMessage(new Object[]{side, rule.label(), typeLabel}));
            } else if (Schema.VertexProperty.RULE_WHEN.equals((Object)side)) {
                if (schemaConcept.isType()) {
                    RuleImpl.from(rule).addHypothesis(schemaConcept.asType());
                }
            } else if (Schema.VertexProperty.RULE_THEN.equals((Object)side)) {
                if (schemaConcept.isType()) {
                    RuleImpl.from(rule).addConclusion(schemaConcept.asType());
                }
            } else {
                throw GraknTxOperationException.invalidPropertyUse((Concept)rule, (Schema.VertexProperty)side);
            }
        });
        return errors;
    }

    static Optional<String> validateRelationshipHasRolePlayers(Relationship relationship) {
        if (!relationship.rolePlayers(new Role[0]).findAny().isPresent()) {
            return Optional.of(ErrorMessage.VALIDATION_RELATIONSHIP_WITH_NO_ROLE_PLAYERS.getMessage(new Object[]{relationship.id(), relationship.type().label()}));
        }
        return Optional.empty();
    }
}

