/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.kb.internal.ValidateGlobalRules;
import ai.grakn.kb.internal.structure.Casting;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class Validator {
    private final EmbeddedGraknTx<?> graknGraph;
    private final List<String> errorsFound = new ArrayList<String>();

    public Validator(EmbeddedGraknTx graknGraph) {
        this.graknGraph = graknGraph;
    }

    public List<String> getErrorsFound() {
        return this.errorsFound;
    }

    public boolean validate() {
        this.graknGraph.txCache().getModifiedThings().forEach(this::validateThing);
        this.graknGraph.txCache().getNewRelationships().forEach(this::validateRelationship);
        this.graknGraph.txCache().getModifiedRoles().forEach(this::validateRole);
        this.graknGraph.txCache().getModifiedCastings().forEach(this::validateCasting);
        this.graknGraph.txCache().getModifiedRelationshipTypes().forEach(this::validateRelationType);
        this.graknGraph.txCache().getModifiedRules().forEach(rule -> this.validateRule(this.graknGraph, (Rule)rule));
        return this.errorsFound.size() == 0;
    }

    private void validateRule(EmbeddedGraknTx<?> graph, Rule rule) {
        Set<String> labelErrors = ValidateGlobalRules.validateRuleSchemaConceptExist(graph, rule);
        this.errorsFound.addAll(labelErrors);
        if (labelErrors.isEmpty()) {
            Set<String> ontologicalErrors = ValidateGlobalRules.validateRuleOntologically(graph, rule);
            this.errorsFound.addAll(ontologicalErrors);
            if (ontologicalErrors.isEmpty()) {
                this.errorsFound.addAll(ValidateGlobalRules.validateRuleIsValidHornClause(graph, rule));
            }
        }
    }

    private void validateCasting(Casting casting) {
        this.errorsFound.addAll(ValidateGlobalRules.validatePlaysAndRelatesStructure(casting));
    }

    private void validateRole(Role role) {
        ValidateGlobalRules.validateHasSingleIncomingRelatesEdge(role).ifPresent(this.errorsFound::add);
    }

    private void validateRelationType(RelationshipType relationshipType) {
        ValidateGlobalRules.validateHasMinimumRoles(relationshipType).ifPresent(this.errorsFound::add);
        this.errorsFound.addAll(ValidateGlobalRules.validateRelationTypesToRolesSchema(relationshipType));
    }

    private void validateThing(Thing thing) {
        ValidateGlobalRules.validateInstancePlaysAllRequiredRoles(thing).ifPresent(this.errorsFound::add);
    }

    private void validateRelationship(Relationship relationship) {
        ValidateGlobalRules.validateRelationshipHasRolePlayers(relationship).ifPresent(this.errorsFound::add);
    }
}

