/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.concept.ThingImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class AttributeImpl<D>
extends ThingImpl<Attribute<D>, AttributeType<D>>
implements Attribute<D> {
    private AttributeImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    private AttributeImpl(VertexElement vertexElement, AttributeType<D> type, Object value) {
        super(vertexElement, type);
        this.setValue(value);
    }

    public static <D> AttributeImpl<D> get(VertexElement vertexElement) {
        return new AttributeImpl<D>(vertexElement);
    }

    public static <D> AttributeImpl<D> create(VertexElement vertexElement, AttributeType<D> type, Object value) {
        Object persistenceValue = AttributeImpl.castValue(type.dataType(), value);
        AttributeImpl<D> attribute = new AttributeImpl<D>(vertexElement, type, persistenceValue);
        String index = Schema.generateAttributeIndex((Label)type.label(), (String)value.toString());
        vertexElement.property(Schema.VertexProperty.INDEX, index);
        vertexElement.tx().txCache().addNewAttribute(index, attribute.id());
        return attribute;
    }

    private static Object castValue(AttributeType.DataType dataType, Object value) {
        try {
            if (dataType.equals(AttributeType.DataType.DOUBLE)) {
                return ((Number)value).doubleValue();
            }
            if (dataType.equals(AttributeType.DataType.LONG)) {
                if (value instanceof Double) {
                    throw new ClassCastException();
                }
                return ((Number)value).longValue();
            }
            if (dataType.equals(AttributeType.DataType.DATE) && value instanceof Long) {
                return value;
            }
            return dataType.getPersistenceValue(value);
        }
        catch (ClassCastException e) {
            throw GraknTxOperationException.invalidAttributeValue((Object)value, (AttributeType.DataType)dataType);
        }
    }

    public AttributeType.DataType<D> dataType() {
        return ((AttributeType)this.type()).dataType();
    }

    public Stream<Thing> owners() {
        Stream implicitOwners = this.getShortcutNeighbours(false, new AttributeType[0]);
        Stream edgeOwners = this.neighbours(Direction.IN, Schema.EdgeLabel.ATTRIBUTE);
        return Stream.concat(implicitOwners, edgeOwners);
    }

    private void setValue(Object value) {
        Schema.VertexProperty property = this.dataType().getVertexProperty();
        this.vertex().propertyImmutable(property, value, this.vertex().property(property));
    }

    public D value() {
        return (D)this.dataType().getValue(this.vertex().property(this.dataType().getVertexProperty()));
    }

    @Override
    public String innerToString() {
        return super.innerToString() + "- Value [" + this.value() + "] ";
    }

    public static AttributeImpl from(Attribute attribute) {
        return (AttributeImpl)attribute;
    }
}

