/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.Keyspace;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.CacheOwner;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.Shard;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class ConceptImpl
implements Concept,
ConceptVertex,
CacheOwner {
    private final Set<Cache> registeredCaches = new HashSet<Cache>();
    private final Cache<Shard> currentShard = Cache.createTxCache(this, Cacheable.shard(), () -> {
        String currentShardId = (String)this.vertex().property(Schema.VertexProperty.CURRENT_SHARD);
        Vertex shardVertex = (Vertex)this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)currentShardId).next();
        return this.vertex().tx().factory().buildShard(shardVertex);
    });
    private final Cache<Long> shardCount = Cache.createSessionCache(this, Cacheable.number(), () -> this.shards().count());
    private final Cache<ConceptId> conceptId = Cache.createPersistentCache(this, Cacheable.conceptId(), () -> ConceptId.of((String)((String)this.vertex().property(Schema.VertexProperty.ID))));
    private final VertexElement vertexElement;

    ConceptImpl(VertexElement vertexElement) {
        this.vertexElement = vertexElement;
    }

    @Override
    public VertexElement vertex() {
        return this.vertexElement;
    }

    <X extends Concept> X getThis() {
        return (X)this;
    }

    public void delete() throws GraknTxOperationException {
        this.deleteNode();
    }

    public Keyspace keyspace() {
        return this.vertex().tx().keyspace();
    }

    public boolean isDeleted() {
        return this.vertex().isDeleted();
    }

    public void deleteNode() {
        this.vertex().tx().txCache().remove(this);
        this.vertex().delete();
    }

    @Override
    public Collection<Cache> caches() {
        return this.registeredCaches;
    }

    <X extends Concept> Stream<X> neighbours(Direction direction, Schema.EdgeLabel label) {
        switch (direction) {
            case BOTH: {
                return this.vertex().getEdgesOfType(direction, label).flatMap(edge -> Stream.of(this.vertex().tx().factory().buildConcept(edge.source()), this.vertex().tx().factory().buildConcept(edge.target())));
            }
            case IN: {
                return this.vertex().getEdgesOfType(direction, label).map(edge -> this.vertex().tx().factory().buildConcept(edge.source()));
            }
            case OUT: {
                return this.vertex().getEdgesOfType(direction, label).map(edge -> this.vertex().tx().factory().buildConcept(edge.target()));
            }
        }
        throw GraknTxOperationException.invalidDirection((Direction)direction);
    }

    EdgeElement putEdge(ConceptVertex to, Schema.EdgeLabel label) {
        return this.vertex().putEdge(to.vertex(), label);
    }

    EdgeElement addEdge(ConceptVertex to, Schema.EdgeLabel label) {
        return this.vertex().addEdge(to.vertex(), label);
    }

    void deleteEdge(Direction direction, Schema.EdgeLabel label, Concept ... to) {
        if (to.length == 0) {
            this.vertex().deleteEdge(direction, label, new VertexElement[0]);
        } else {
            VertexElement[] targets = new VertexElement[to.length];
            for (int i = 0; i < to.length; ++i) {
                targets[i] = ((ConceptImpl)to[i]).vertex();
            }
            this.vertex().deleteEdge(direction, label, targets);
        }
    }

    public Schema.BaseType baseType() {
        return Schema.BaseType.valueOf((String)this.vertex().label());
    }

    public ConceptId id() {
        return this.conceptId.get();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConceptImpl concept = (ConceptImpl)object;
        return this.id().equals((Object)concept.id());
    }

    public final String toString() {
        if (this.vertex().tx().isValidElement((Element)this.vertex().element())) {
            return this.innerToString();
        }
        return "Id [" + this.vertex().id() + "]";
    }

    String innerToString() {
        String message = "Base Type [" + this.baseType() + "] ";
        if (this.id() != null) {
            message = message + "- Id [" + this.id() + "] ";
        }
        return message;
    }

    public void createShard() {
        VertexElement shardVertex = this.vertex().tx().addVertexElement(Schema.BaseType.SHARD, new ConceptId[0]);
        Shard shard = this.vertex().tx().factory().buildShard(this, shardVertex);
        this.vertex().property(Schema.VertexProperty.CURRENT_SHARD, shard.id());
        this.currentShard.set(shard);
        if (this.shardCount.isPresent()) {
            this.shardCount.set(this.shardCount() + 1L);
        }
    }

    public Stream<Shard> shards() {
        return this.vertex().getEdgesOfType(Direction.IN, Schema.EdgeLabel.SHARD).map(EdgeElement::source).map(edge -> this.vertex().tx().factory().buildShard((VertexElement)edge));
    }

    public Long shardCount() {
        return this.shardCount.get();
    }

    public Shard currentShard() {
        return this.currentShard.get();
    }
}

