/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.TemporaryWriteException;
import ai.grakn.graql.Pattern;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.concept.AttributeTypeImpl;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.EntityImpl;
import ai.grakn.kb.internal.concept.EntityTypeImpl;
import ai.grakn.kb.internal.concept.RelationshipEdge;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.RelationshipTypeImpl;
import ai.grakn.kb.internal.concept.RoleImpl;
import ai.grakn.kb.internal.concept.RuleImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.AbstractElement;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.Shard;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public final class ElementFactory {
    private final EmbeddedGraknTx tx;

    public ElementFactory(EmbeddedGraknTx tx) {
        this.tx = tx;
    }

    private <X extends Concept, E extends AbstractElement> X getOrBuildConcept(E element, ConceptId conceptId, Function<E, X> conceptBuilder) {
        if (!this.tx.txCache().isConceptCached(conceptId)) {
            Concept newConcept = (Concept)conceptBuilder.apply(element);
            this.tx.txCache().cacheConcept(newConcept);
        }
        return this.tx.txCache().getCachedConcept(conceptId);
    }

    private <X extends Concept> X getOrBuildConcept(VertexElement element, Function<VertexElement, X> conceptBuilder) {
        ConceptId conceptId = ConceptId.of((String)((String)element.property(Schema.VertexProperty.ID)));
        return this.getOrBuildConcept(element, conceptId, conceptBuilder);
    }

    private <X extends Concept> X getOrBuildConcept(EdgeElement element, Function<EdgeElement, X> conceptBuilder) {
        ConceptId conceptId = ConceptId.of((String)element.id().getValue());
        return this.getOrBuildConcept(element, conceptId, conceptBuilder);
    }

    public <V> AttributeTypeImpl<V> buildAttributeType(VertexElement vertex, AttributeType<V> type, AttributeType.DataType<V> dataType) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> AttributeTypeImpl.create(v, type, dataType));
    }

    <V> AttributeImpl<V> buildAttribute(VertexElement vertex, AttributeType<V> type, Object persitedValue) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> AttributeImpl.create(v, type, persitedValue));
    }

    public RelationshipTypeImpl buildRelationshipType(VertexElement vertex, RelationshipType type) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> RelationshipTypeImpl.create(v, type));
    }

    RelationshipImpl buildRelation(VertexElement vertex, RelationshipType type) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> RelationshipImpl.create(this.buildRelationReified((VertexElement)v, type)));
    }

    public RelationshipImpl buildRelation(EdgeElement edge, RelationshipType type, Role owner, Role value) {
        return this.getOrBuildConcept(edge, (EdgeElement e) -> RelationshipImpl.create(RelationshipEdge.create(type, owner, value, edge)));
    }

    RelationshipImpl buildRelation(EdgeElement edge) {
        return this.getOrBuildConcept(edge, (EdgeElement e) -> RelationshipImpl.create(RelationshipEdge.get(edge)));
    }

    RelationshipReified buildRelationReified(VertexElement vertex, RelationshipType type) {
        return RelationshipReified.create(vertex, type);
    }

    public EntityTypeImpl buildEntityType(VertexElement vertex, EntityType type) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> EntityTypeImpl.create(v, type));
    }

    EntityImpl buildEntity(VertexElement vertex, EntityType type) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> EntityImpl.create(v, type));
    }

    public RuleImpl buildRule(VertexElement vertex, Rule type, Pattern when, Pattern then) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> RuleImpl.create(v, type, when, then));
    }

    public RoleImpl buildRole(VertexElement vertex, Role type) {
        return this.getOrBuildConcept(vertex, (VertexElement v) -> RoleImpl.create(v, type));
    }

    public <X extends Concept> X buildConcept(Vertex vertex) {
        return this.buildConcept(this.buildVertexElement(vertex));
    }

    public <X extends Concept> X buildConcept(VertexElement vertexElement) {
        Schema.BaseType type;
        try {
            type = this.getBaseType(vertexElement);
        }
        catch (IllegalStateException e) {
            throw TemporaryWriteException.indexOverlap((Vertex)((Vertex)vertexElement.element()), (Exception)e);
        }
        ConceptId conceptId = ConceptId.of((String)((String)vertexElement.property(Schema.VertexProperty.ID)));
        if (!this.tx.txCache().isConceptCached(conceptId)) {
            ConceptVertex concept;
            switch (type) {
                case RELATIONSHIP: {
                    concept = RelationshipImpl.create(RelationshipReified.get(vertexElement));
                    break;
                }
                case TYPE: {
                    concept = new TypeImpl(vertexElement);
                    break;
                }
                case ROLE: {
                    concept = RoleImpl.get(vertexElement);
                    break;
                }
                case RELATIONSHIP_TYPE: {
                    concept = RelationshipTypeImpl.get(vertexElement);
                    break;
                }
                case ENTITY: {
                    concept = EntityImpl.get(vertexElement);
                    break;
                }
                case ENTITY_TYPE: {
                    concept = EntityTypeImpl.get(vertexElement);
                    break;
                }
                case ATTRIBUTE_TYPE: {
                    concept = AttributeTypeImpl.get(vertexElement);
                    break;
                }
                case ATTRIBUTE: {
                    concept = AttributeImpl.get(vertexElement);
                    break;
                }
                case RULE: {
                    concept = RuleImpl.get(vertexElement);
                    break;
                }
                default: {
                    throw GraknTxOperationException.unknownConcept((String)type.name());
                }
            }
            this.tx.txCache().cacheConcept((Concept)concept);
        }
        return this.tx.txCache().getCachedConcept(conceptId);
    }

    public <X extends Concept> X buildConcept(Edge edge) {
        return this.buildConcept(this.buildEdgeElement(edge));
    }

    public <X extends Concept> X buildConcept(EdgeElement edgeElement) {
        Schema.EdgeLabel label = Schema.EdgeLabel.valueOf((String)edgeElement.label().toUpperCase(Locale.getDefault()));
        ConceptId conceptId = ConceptId.of((String)edgeElement.id().getValue());
        if (!this.tx.txCache().isConceptCached(conceptId)) {
            RelationshipImpl concept;
            switch (label) {
                case ATTRIBUTE: {
                    concept = RelationshipImpl.create(RelationshipEdge.get(edgeElement));
                    break;
                }
                default: {
                    throw GraknTxOperationException.unknownConcept((String)label.name());
                }
            }
            this.tx.txCache().cacheConcept((Concept)concept);
        }
        return this.tx.txCache().getCachedConcept(conceptId);
    }

    private Schema.BaseType getBaseType(VertexElement vertex) {
        try {
            return Schema.BaseType.valueOf((String)vertex.label());
        }
        catch (IllegalArgumentException e) {
            Optional<VertexElement> type = vertex.getEdgesOfType(Direction.OUT, Schema.EdgeLabel.SHARD).map(EdgeElement::target).findAny();
            if (type.isPresent()) {
                String label = type.get().label();
                if (label.equals(Schema.BaseType.ENTITY_TYPE.name())) {
                    return Schema.BaseType.ENTITY;
                }
                if (label.equals(Schema.BaseType.RELATIONSHIP_TYPE.name())) {
                    return Schema.BaseType.RELATIONSHIP;
                }
                if (label.equals(Schema.BaseType.ATTRIBUTE_TYPE.name())) {
                    return Schema.BaseType.ATTRIBUTE;
                }
            }
            throw new IllegalStateException("Could not determine the base type of vertex [" + vertex + "]");
        }
    }

    public EdgeElement buildEdgeElement(Edge edge) {
        return new EdgeElement(this.tx, edge);
    }

    Shard buildShard(ConceptImpl shardOwner, VertexElement vertexElement) {
        return new Shard(shardOwner, vertexElement);
    }

    Shard buildShard(VertexElement vertexElement) {
        return new Shard(vertexElement);
    }

    Shard buildShard(Vertex vertex) {
        return new Shard(this.buildVertexElement(vertex));
    }

    public VertexElement buildVertexElement(Vertex vertex) {
        if (!this.tx.isValidElement((Element)vertex)) {
            Objects.requireNonNull(vertex);
            throw GraknTxOperationException.invalidElement((Element)vertex);
        }
        return new VertexElement(this.tx, vertex);
    }

    public VertexElement addVertexElement(Schema.BaseType baseType, ConceptId ... conceptIds) {
        Vertex vertex = this.tx.getTinkerPopGraph().addVertex(baseType.name());
        String newConceptId = "V" + vertex.id().toString();
        if (conceptIds.length > 1) {
            throw new IllegalArgumentException("Cannot provide more than one concept id when creating a new concept");
        }
        if (conceptIds.length == 1) {
            newConceptId = conceptIds[0].getValue();
        }
        vertex.property(Schema.VertexProperty.ID.name(), (Object)newConceptId);
        this.tx.txCache().writeOccurred();
        return new VertexElement(this.tx, vertex);
    }
}

