/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.CacheOwner;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.RelationshipStructure;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipEdge
implements RelationshipStructure,
CacheOwner {
    private final Set<Cache> registeredCaches = new HashSet<Cache>();
    private final Logger LOG = LoggerFactory.getLogger(RelationshipEdge.class);
    private final EdgeElement edgeElement;
    private final Cache<RelationshipType> relationType = Cache.createTxCache(this, Cacheable.concept(), () -> this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID)))));
    private final Cache<Role> ownerRole = Cache.createTxCache(this, Cacheable.concept(), () -> this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_ROLE_OWNER_LABEL_ID)))));
    private final Cache<Role> valueRole = Cache.createTxCache(this, Cacheable.concept(), () -> this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_ROLE_VALUE_LABEL_ID)))));
    private final Cache<Thing> owner = Cache.createTxCache(this, Cacheable.concept(), () -> (Thing)this.edge().tx().factory().buildConcept(this.edge().source()));
    private final Cache<Thing> value = Cache.createTxCache(this, Cacheable.concept(), () -> (Thing)this.edge().tx().factory().buildConcept(this.edge().target()));

    private RelationshipEdge(EdgeElement edgeElement) {
        this.edgeElement = edgeElement;
    }

    private RelationshipEdge(RelationshipType relationshipType, Role ownerRole, Role valueRole, EdgeElement edgeElement) {
        this(edgeElement);
        edgeElement.propertyImmutable(Schema.EdgeProperty.RELATIONSHIP_ROLE_OWNER_LABEL_ID, ownerRole, null, o -> o.labelId().getValue());
        edgeElement.propertyImmutable(Schema.EdgeProperty.RELATIONSHIP_ROLE_VALUE_LABEL_ID, valueRole, null, v -> v.labelId().getValue());
        edgeElement.propertyImmutable(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID, relationshipType, null, t -> t.labelId().getValue());
        this.relationType.set(relationshipType);
        this.ownerRole.set(ownerRole);
        this.valueRole.set(valueRole);
    }

    public static RelationshipEdge get(EdgeElement edgeElement) {
        return new RelationshipEdge(edgeElement);
    }

    public static RelationshipEdge create(RelationshipType relationshipType, Role ownerRole, Role valueRole, EdgeElement edgeElement) {
        return new RelationshipEdge(relationshipType, ownerRole, valueRole, edgeElement);
    }

    private EdgeElement edge() {
        return this.edgeElement;
    }

    @Override
    public ConceptId id() {
        return ConceptId.of((String)this.edge().id().getValue());
    }

    @Override
    public Keyspace keyspace() {
        return this.edge().tx().keyspace();
    }

    @Override
    public RelationshipReified reify() {
        this.LOG.debug("Reifying concept [" + this.id() + "]");
        VertexElement relationVertex = this.edge().tx().addVertexElement(Schema.BaseType.RELATIONSHIP, this.id());
        RelationshipReified relationReified = this.edge().tx().factory().buildRelationReified(relationVertex, this.type());
        this.delete();
        return relationReified;
    }

    @Override
    public boolean isReified() {
        return false;
    }

    @Override
    public RelationshipType type() {
        return this.relationType.get();
    }

    @Override
    public Map<Role, Set<Thing>> allRolePlayers() {
        HashMap<Role, Set<Thing>> result = new HashMap<Role, Set<Thing>>();
        result.put(this.ownerRole(), Collections.singleton(this.owner()));
        result.put(this.valueRole(), Collections.singleton(this.value()));
        return result;
    }

    @Override
    public Stream<Thing> rolePlayers(Role ... roles) {
        if (roles.length == 0) {
            return Stream.of(this.owner(), this.value());
        }
        HashSet<Thing> result = new HashSet<Thing>();
        for (Role role : roles) {
            if (role.equals(this.ownerRole())) {
                result.add(this.owner());
                continue;
            }
            if (!role.equals(this.valueRole())) continue;
            result.add(this.value());
        }
        return result.stream();
    }

    public Role ownerRole() {
        return this.ownerRole.get();
    }

    public Thing owner() {
        return this.owner.get();
    }

    public Role valueRole() {
        return this.valueRole.get();
    }

    public Thing value() {
        return this.value.get();
    }

    @Override
    public void delete() {
        this.edge().delete();
    }

    @Override
    public boolean isDeleted() {
        return this.edgeElement.isDeleted();
    }

    @Override
    public boolean isInferred() {
        return this.edge().propertyBoolean(Schema.EdgeProperty.IS_INFERRED);
    }

    public String toString() {
        return "ID [" + this.id() + "] Type [" + this.type().label() + "] Roles and Role Players: \nRole [" + this.ownerRole().label() + "] played by [" + this.owner().id() + "] \nRole [" + this.valueRole().label() + "] played by [" + this.value().id() + "] \n";
    }

    @Override
    public Collection<Cache> caches() {
        return this.registeredCaches;
    }
}

