/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.CacheOwner;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.RelationshipReified;
import ai.grakn.kb.internal.concept.RelationshipStructure;
import ai.grakn.kb.internal.concept.ThingImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class RelationshipImpl
implements Relationship,
ConceptVertex,
CacheOwner {
    private RelationshipStructure relationshipStructure;

    private RelationshipImpl(RelationshipStructure relationshipStructure) {
        this.relationshipStructure = relationshipStructure;
        if (relationshipStructure.isReified()) {
            relationshipStructure.reify().owner(this);
        }
    }

    public static RelationshipImpl create(RelationshipStructure relationshipStructure) {
        return new RelationshipImpl(relationshipStructure);
    }

    public Optional<RelationshipReified> reified() {
        if (!this.relationshipStructure.isReified()) {
            return Optional.empty();
        }
        return Optional.of(this.relationshipStructure.reify());
    }

    public RelationshipReified reify() {
        if (this.relationshipStructure.isReified()) {
            return this.relationshipStructure.reify();
        }
        Map<Role, Set<Thing>> rolePlayers = this.structure().allRolePlayers();
        this.relationshipStructure = this.relationshipStructure.reify();
        rolePlayers.forEach((role, things) -> {
            Thing thing = (Thing)Iterables.getOnlyElement((Iterable)things);
            this.assign((Role)role, thing);
        });
        return this.relationshipStructure.reify();
    }

    public RelationshipStructure structure() {
        return this.relationshipStructure;
    }

    public Relationship has(Attribute attribute) {
        this.relhas(attribute);
        return this;
    }

    public Relationship relhas(Attribute attribute) {
        return this.reify().relhas(attribute);
    }

    public Stream<Attribute<?>> attributes(AttributeType[] attributeTypes) {
        return this.readFromReified(relationReified -> relationReified.attributes(attributeTypes));
    }

    public Stream<Attribute<?>> keys(AttributeType[] attributeTypes) {
        return this.reified().map(relationshipReified -> relationshipReified.attributes(attributeTypes)).orElseGet(Stream::empty);
    }

    public RelationshipType type() {
        return this.structure().type();
    }

    public Stream<Relationship> relationships(Role ... roles) {
        return this.readFromReified(relationReified -> relationReified.relationships(roles));
    }

    public Stream<Role> roles() {
        return this.readFromReified(ThingImpl::roles);
    }

    private <X> Stream<X> readFromReified(Function<RelationshipReified, Stream<X>> producer) {
        return this.reified().map(producer).orElseGet(Stream::empty);
    }

    public Map<Role, Set<Thing>> rolePlayersMap() {
        return this.structure().allRolePlayers();
    }

    public Stream<Thing> rolePlayers(Role ... roles) {
        return this.structure().rolePlayers(roles);
    }

    public Relationship assign(Role role, Thing player) {
        this.reify().addRolePlayer(role, player);
        return this;
    }

    public Relationship unhas(Attribute attribute) {
        this.reified().ifPresent(rel -> {
            Relationship cfr_ignored_0 = (Relationship)rel.unhas(attribute);
        });
        return this;
    }

    public boolean isInferred() {
        return this.structure().isInferred();
    }

    public void unassign(Role role, Thing player) {
        this.reified().ifPresent(relationshipReified -> relationshipReified.removeRolePlayer(role, player));
    }

    void cleanUp() {
        Stream<Thing> rolePlayers = this.rolePlayers(new Role[0]);
        boolean performDeletion = rolePlayers.noneMatch(thing -> thing != null && thing.id() != null);
        if (performDeletion) {
            this.delete();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.id().equals((Object)((RelationshipImpl)object).id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public String toString() {
        return this.structure().toString();
    }

    public ConceptId id() {
        return this.structure().id();
    }

    public Keyspace keyspace() {
        return this.structure().keyspace();
    }

    public void delete() {
        this.structure().delete();
    }

    public boolean isDeleted() {
        return this.structure().isDeleted();
    }

    @Override
    public VertexElement vertex() {
        return this.reify().vertex();
    }

    public static RelationshipImpl from(Relationship relationship) {
        return (RelationshipImpl)relationship;
    }

    @Override
    public Collection<Cache> caches() {
        return this.structure().caches();
    }

    public Relationship attributeInferred(Attribute attribute) {
        this.reify().attributeInferred(attribute);
        return this;
    }
}

