/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Type;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class RoleImpl
extends SchemaConceptImpl<Role>
implements Role {
    private final Cache<Set<Type>> cachedDirectPlayedByTypes = Cache.createSessionCache(this, Cacheable.set(), () -> this.neighbours(Direction.IN, Schema.EdgeLabel.PLAYS).collect(Collectors.toSet()));
    private final Cache<Set<RelationshipType>> cachedRelationTypes = Cache.createSessionCache(this, Cacheable.set(), () -> this.neighbours(Direction.IN, Schema.EdgeLabel.RELATES).collect(Collectors.toSet()));

    private RoleImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    private RoleImpl(VertexElement vertexElement, Role type) {
        super(vertexElement, type);
    }

    public static RoleImpl get(VertexElement vertexElement) {
        return new RoleImpl(vertexElement);
    }

    public static RoleImpl create(VertexElement vertexElement, Role type) {
        RoleImpl role = new RoleImpl(vertexElement, type);
        vertexElement.tx().txCache().trackForValidation(role);
        return role;
    }

    public Stream<RelationshipType> relationships() {
        return this.cachedRelationTypes.get().stream();
    }

    void addCachedRelationType(RelationshipType newRelationshipType) {
        this.cachedRelationTypes.ifPresent(set -> set.add(newRelationshipType));
    }

    void deleteCachedRelationType(RelationshipType oldRelationshipType) {
        this.cachedRelationTypes.ifPresent(set -> set.remove(oldRelationshipType));
    }

    public Stream<Type> players() {
        return this.cachedDirectPlayedByTypes.get().stream().flatMap(Type::subs);
    }

    void addCachedDirectPlaysByType(Type newType) {
        this.cachedDirectPlayedByTypes.ifPresent(set -> set.add(newType));
    }

    void deleteCachedDirectPlaysByType(Type oldType) {
        this.cachedDirectPlayedByTypes.ifPresent(set -> set.remove(oldType));
    }

    public Stream<Casting> rolePlayers() {
        return this.relationships().flatMap(RelationshipType::instances).map(relation -> RelationshipImpl.from(relation).reified()).flatMap(CommonUtil::optionalToStream).flatMap(relation -> relation.castingsRelation(this));
    }

    @Override
    boolean deletionAllowed() {
        return super.deletionAllowed() && !this.neighbours(Direction.IN, Schema.EdgeLabel.RELATES).findAny().isPresent() && !this.neighbours(Direction.IN, Schema.EdgeLabel.PLAYS).findAny().isPresent() && !this.rolePlayers().findAny().isPresent();
    }

    @Override
    void trackRolePlayers() {
    }
}

