/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.graql.Pattern;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class RuleImpl
extends SchemaConceptImpl<Rule>
implements Rule {
    private RuleImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    private RuleImpl(VertexElement vertexElement, Rule type, Pattern when, Pattern then) {
        super(vertexElement, type);
        this.vertex().propertyImmutable(Schema.VertexProperty.RULE_WHEN, when, this.when(), Object::toString);
        this.vertex().propertyImmutable(Schema.VertexProperty.RULE_THEN, then, this.then(), Object::toString);
    }

    public static RuleImpl get(VertexElement vertexElement) {
        return new RuleImpl(vertexElement);
    }

    public static RuleImpl create(VertexElement vertexElement, Rule type, Pattern when, Pattern then) {
        RuleImpl rule = new RuleImpl(vertexElement, type, when, then);
        vertexElement.tx().txCache().trackForValidation(rule);
        return rule;
    }

    @Override
    void trackRolePlayers() {
    }

    public Pattern when() {
        return this.parsePattern((String)this.vertex().property(Schema.VertexProperty.RULE_WHEN));
    }

    public Pattern then() {
        return this.parsePattern((String)this.vertex().property(Schema.VertexProperty.RULE_THEN));
    }

    public Stream<Type> whenTypes() {
        return this.neighbours(Direction.OUT, Schema.EdgeLabel.HYPOTHESIS);
    }

    public Stream<Type> thenTypes() {
        return this.neighbours(Direction.OUT, Schema.EdgeLabel.CONCLUSION);
    }

    public void addHypothesis(Type type) {
        this.putEdge(ConceptVertex.from((Concept)type), Schema.EdgeLabel.HYPOTHESIS);
    }

    public void addConclusion(Type type) {
        this.putEdge(ConceptVertex.from((Concept)type), Schema.EdgeLabel.CONCLUSION);
    }

    private Pattern parsePattern(String value) {
        if (value == null) {
            return null;
        }
        return this.vertex().tx().graql().parser().parsePattern(value);
    }

    public static <X extends Type, Y extends Thing> RuleImpl from(Rule type) {
        return (RuleImpl)type;
    }
}

