/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.AttributeImpl;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.concept.RelationshipImpl;
import ai.grakn.kb.internal.concept.TypeImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class ThingImpl<T extends Thing, V extends Type>
extends ConceptImpl
implements Thing {
    private final Cache<Label> cachedInternalType = Cache.createTxCache(this, Cacheable.label(), () -> {
        int typeId = (Integer)this.vertex().property(Schema.VertexProperty.THING_TYPE_LABEL_ID);
        Optional type = this.vertex().tx().getConcept(Schema.VertexProperty.LABEL_ID, typeId);
        return ((Type)type.orElseThrow(() -> GraknTxOperationException.missingType((ConceptId)this.id()))).label();
    });
    private final Cache<V> cachedType = Cache.createTxCache(this, Cacheable.concept(), () -> {
        Optional<Type> type = this.vertex().getEdgesOfType(Direction.OUT, Schema.EdgeLabel.ISA).map(EdgeElement::target).flatMap(edge -> edge.getEdgesOfType(Direction.OUT, Schema.EdgeLabel.SHARD)).map(EdgeElement::target).map(concept -> (Type)this.vertex().tx().factory().buildConcept((VertexElement)concept)).findAny();
        return type.orElseThrow(() -> GraknTxOperationException.noType((Thing)this));
    });

    ThingImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    ThingImpl(VertexElement vertexElement, V type) {
        this(vertexElement);
        super.type((TypeImpl)type);
        super.track();
    }

    private void track() {
        if (this.type().keys().findAny().isPresent()) {
            this.vertex().tx().txCache().trackForValidation(this);
        }
    }

    public boolean isInferred() {
        return this.vertex().propertyBoolean(Schema.VertexProperty.IS_INFERRED);
    }

    @Override
    public void delete() {
        Set<Relationship> relationships = this.castingsInstance().map(casting -> {
            Relationship relationship = casting.getRelationship();
            Role role = casting.getRole();
            relationship.unassign(role, (Thing)this);
            return relationship;
        }).collect(Collectors.toSet());
        this.vertex().tx().txCache().removedInstance(this.type().id());
        this.deleteNode();
        relationships.forEach(relation -> {
            if (relation.type().isImplicit().booleanValue()) {
                relation.delete();
            } else {
                RelationshipImpl rel = (RelationshipImpl)relation;
                rel.cleanUp();
            }
        });
    }

    public String getIndex() {
        return (String)this.vertex().property(Schema.VertexProperty.INDEX);
    }

    public Stream<Attribute<?>> attributes(AttributeType ... attributeTypes) {
        Set<ConceptId> attributeTypesIds = Arrays.stream(attributeTypes).map(Concept::id).collect(Collectors.toSet());
        return this.attributes(this.getShortcutNeighbours(true, new AttributeType[0]), attributeTypesIds);
    }

    public Stream<Attribute<?>> keys(AttributeType ... attributeTypes) {
        Set attributeTypesIds = Arrays.stream(attributeTypes).map(Concept::id).collect(Collectors.toSet());
        Sets.SetView keyTypeIds = this.type().keys().map(Concept::id).collect(Collectors.toSet());
        if (!attributeTypesIds.isEmpty()) {
            keyTypeIds = Sets.intersection(attributeTypesIds, keyTypeIds);
        }
        if (keyTypeIds.isEmpty()) {
            return Stream.empty();
        }
        return this.attributes(this.getShortcutNeighbours(true, new AttributeType[0]), (Set<ConceptId>)keyTypeIds);
    }

    private <X extends Concept> Stream<Attribute<?>> attributes(Stream<X> conceptStream, Set<ConceptId> attributeTypesIds) {
        Stream<Attribute<?>> attributeStream = conceptStream.filter(concept -> concept.isAttribute() && !this.equals(concept)).map(Concept::asAttribute);
        if (!attributeTypesIds.isEmpty()) {
            attributeStream = attributeStream.filter(attribute -> attributeTypesIds.contains(attribute.type().id()));
        }
        return attributeStream;
    }

    Stream<Casting> castingsInstance() {
        return this.vertex().getEdgesOfType(Direction.IN, Schema.EdgeLabel.ROLE_PLAYER).map(edge -> Casting.withThing(edge, this));
    }

    private Set<Integer> implicitLabelsToIds(Set<Label> labels, Set<Schema.ImplicitType> implicitTypes) {
        return labels.stream().flatMap(label -> implicitTypes.stream().map(it -> it.getLabel(label))).map(label -> this.vertex().tx().convertToId((Label)label)).filter(id -> !id.equals(LabelId.invalid())).map(LabelId::getValue).collect(Collectors.toSet());
    }

    <X extends Thing> Stream<X> getShortcutNeighbours(boolean ownerToValueOrdering, AttributeType ... attributeTypes) {
        HashSet<AttributeType> completeAttributeTypes = new HashSet<AttributeType>(Arrays.asList(attributeTypes));
        if (completeAttributeTypes.isEmpty()) {
            completeAttributeTypes.add(this.vertex().tx().getMetaAttributeType());
        }
        Set<Label> attributeHierachyLabels = completeAttributeTypes.stream().flatMap(t -> t.subs()).map(SchemaConcept::label).collect(Collectors.toSet());
        Set<Integer> ownerRoleIds = this.implicitLabelsToIds(attributeHierachyLabels, Sets.newHashSet((Object[])new Schema.ImplicitType[]{Schema.ImplicitType.HAS_OWNER, Schema.ImplicitType.KEY_OWNER}));
        Set<Integer> valueRoleIds = this.implicitLabelsToIds(attributeHierachyLabels, Sets.newHashSet((Object[])new Schema.ImplicitType[]{Schema.ImplicitType.HAS_VALUE, Schema.ImplicitType.KEY_VALUE}));
        GraphTraversal shortcutTraversal = !ownerRoleIds.isEmpty() && !valueRoleIds.isEmpty() ? __.inE((String[])new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).as("edge", new String[0]).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), P.within(ownerToValueOrdering ? ownerRoleIds : valueRoleIds)).outV().outE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), P.within(ownerToValueOrdering ? valueRoleIds : ownerRoleIds)).where(P.neq((Object)"edge")).inV() : __.inE((String[])new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).as("edge", new String[0]).outV().outE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).where(P.neq((Object)"edge")).inV();
        GraphTraversal attributeEdgeTraversal = __.outE((String[])new String[]{Schema.EdgeLabel.ATTRIBUTE.getLabel()}).inV();
        return this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.id().getValue()).union(new Traversal[]{shortcutTraversal, attributeEdgeTraversal}).toStream().map(vertex -> (Thing)this.vertex().tx().buildConcept((Vertex)vertex));
    }

    public Stream<Relationship> relationships(Role ... roles) {
        return Stream.concat(this.reifiedRelations(roles), this.edgeRelations(roles));
    }

    private Stream<Relationship> reifiedRelations(Role ... roles) {
        GraphTraversal traversal = this.vertex().tx().getTinkerTraversal().V(new Object[0]).has(Schema.VertexProperty.ID.name(), (Object)this.id().getValue());
        if (roles.length == 0) {
            traversal.in(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()});
        } else {
            Set roleTypesIds = Arrays.stream(roles).map(r -> r.labelId().getValue()).collect(Collectors.toSet());
            traversal.inE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.ROLE_LABEL_ID.name(), P.within(roleTypesIds)).outV();
        }
        return traversal.toStream().map(vertex -> (Relationship)this.vertex().tx().buildConcept((Vertex)vertex));
    }

    private Stream<Relationship> edgeRelations(Role ... roles) {
        HashSet<Role> roleSet = new HashSet<Role>(Arrays.asList(roles));
        Stream<EdgeElement> stream = this.vertex().getEdgesOfType(Direction.BOTH, Schema.EdgeLabel.ATTRIBUTE);
        if (!roleSet.isEmpty()) {
            stream = stream.filter(edge -> {
                Role roleOwner = (Role)this.vertex().tx().getSchemaConcept(LabelId.of((Integer)((Integer)edge.property(Schema.EdgeProperty.RELATIONSHIP_ROLE_OWNER_LABEL_ID))));
                return roleSet.contains(roleOwner);
            });
        }
        return stream.map(edge -> this.vertex().tx().factory().buildRelation((EdgeElement)edge));
    }

    public Stream<Role> roles() {
        return this.castingsInstance().map(Casting::getRole);
    }

    public T has(Attribute attribute) {
        this.relhas(attribute);
        return (T)((Thing)this.getThis());
    }

    public T attributeInferred(Attribute attribute) {
        this.attributeRelationship(attribute, true);
        return (T)((Thing)this.getThis());
    }

    public Relationship relhas(Attribute attribute) {
        return this.attributeRelationship(attribute, false);
    }

    private Relationship attributeRelationship(Attribute attribute, boolean isInferred) {
        Schema.ImplicitType has = Schema.ImplicitType.HAS;
        Schema.ImplicitType hasValue = Schema.ImplicitType.HAS_VALUE;
        Schema.ImplicitType hasOwner = Schema.ImplicitType.HAS_OWNER;
        if (this.type().keys().anyMatch(rt -> rt.equals(attribute.type()))) {
            has = Schema.ImplicitType.KEY;
            hasValue = Schema.ImplicitType.KEY_VALUE;
            hasOwner = Schema.ImplicitType.KEY_OWNER;
        }
        Label label = attribute.type().label();
        RelationshipType hasAttribute = (RelationshipType)this.vertex().tx().getSchemaConcept(has.getLabel(label));
        Role hasAttributeOwner = (Role)this.vertex().tx().getSchemaConcept(hasOwner.getLabel(label));
        Role hasAttributeValue = (Role)this.vertex().tx().getSchemaConcept(hasValue.getLabel(label));
        if (hasAttribute == null || hasAttributeOwner == null || hasAttributeValue == null || this.type().playing().noneMatch(play -> play.equals(hasAttributeOwner))) {
            throw GraknTxOperationException.hasNotAllowed((Thing)this, (Attribute)attribute);
        }
        EdgeElement attributeEdge = this.addEdge(AttributeImpl.from(attribute), Schema.EdgeLabel.ATTRIBUTE);
        if (isInferred) {
            attributeEdge.property(Schema.EdgeProperty.IS_INFERRED, true);
        }
        return this.vertex().tx().factory().buildRelation(attributeEdge, hasAttribute, hasAttributeOwner, hasAttributeValue);
    }

    public T unhas(Attribute attribute) {
        Role roleHasOwner = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.HAS_OWNER.getLabel(attribute.type().label()));
        Role roleKeyOwner = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.KEY_OWNER.getLabel(attribute.type().label()));
        Role roleHasValue = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.HAS_VALUE.getLabel(attribute.type().label()));
        Role roleKeyValue = (Role)this.vertex().tx().getSchemaConcept(Schema.ImplicitType.KEY_VALUE.getLabel(attribute.type().label()));
        Stream<Relationship> relationships = this.relationships(this.filterNulls(roleHasOwner, roleKeyOwner));
        relationships.filter(relationship -> {
            Stream rolePlayers = relationship.rolePlayers(this.filterNulls(roleHasValue, roleKeyValue));
            return rolePlayers.anyMatch(rolePlayer -> rolePlayer.equals(attribute));
        }).forEach(Concept::delete);
        return (T)((Thing)this.getThis());
    }

    private Role[] filterNulls(Role ... roles) {
        return (Role[])Arrays.stream(roles).filter(Objects::nonNull).toArray(Role[]::new);
    }

    public V type() {
        return (V)((Type)this.cachedType.get());
    }

    private void type(TypeImpl type) {
        if (type != null) {
            this.cachedType.set(type);
            type.currentShard().link(this);
            this.setInternalType(type);
        }
    }

    private void setInternalType(Type type) {
        this.cachedInternalType.set(type.label());
        this.vertex().property(Schema.VertexProperty.THING_TYPE_LABEL_ID, type.labelId().getValue());
    }

    Label getInternalType() {
        return this.cachedInternalType.get();
    }
}

