/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.concept;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.concept.AttributeTypeImpl;
import ai.grakn.kb.internal.concept.ConceptVertex;
import ai.grakn.kb.internal.concept.RoleImpl;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.kb.internal.concept.ThingImpl;
import ai.grakn.kb.internal.structure.Casting;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.kb.internal.structure.Shard;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class TypeImpl<T extends Type, V extends Thing>
extends SchemaConceptImpl<T>
implements Type {
    private final Cache<Boolean> cachedIsAbstract = Cache.createSessionCache(this, Cacheable.bool(), () -> this.vertex().propertyBoolean(Schema.VertexProperty.IS_ABSTRACT));
    private final Cache<Map<Role, Boolean>> cachedDirectPlays = Cache.createSessionCache(this, Cacheable.map(), () -> {
        HashMap roleTypes = new HashMap();
        this.vertex().getEdgesOfType(Direction.OUT, Schema.EdgeLabel.PLAYS).forEach(edge -> {
            Role role = (Role)this.vertex().tx().factory().buildConcept(edge.target());
            Boolean required = edge.propertyBoolean(Schema.EdgeProperty.REQUIRED);
            roleTypes.put(role, required);
        });
        return roleTypes;
    });

    TypeImpl(VertexElement vertexElement) {
        super(vertexElement);
    }

    TypeImpl(VertexElement vertexElement, T superType) {
        super(vertexElement, superType);
        this.createShard();
    }

    V putInstance(Schema.BaseType instanceBaseType, Supplier<V> finder, BiFunction<VertexElement, T, V> producer, boolean isInferred) {
        this.preCheckForInstanceCreation();
        Object instance = (Thing)finder.get();
        if (instance == null) {
            instance = this.addInstance(instanceBaseType, producer, isInferred, false);
        } else if (isInferred && !instance.isInferred()) {
            throw GraknTxOperationException.nonInferredThingExists((Thing)instance);
        }
        return (V)instance;
    }

    V addInstance(Schema.BaseType instanceBaseType, BiFunction<VertexElement, T, V> producer, boolean isInferred, boolean checkNeeded) {
        if (checkNeeded) {
            this.preCheckForInstanceCreation();
        }
        if (this.isAbstract().booleanValue()) {
            throw GraknTxOperationException.addingInstancesToAbstractType((Type)this);
        }
        VertexElement instanceVertex = this.vertex().tx().addVertexElement(instanceBaseType, new ConceptId[0]);
        if (!Schema.MetaSchema.isMetaLabel((Label)this.label())) {
            this.vertex().tx().txCache().addedInstance(this.id());
            if (isInferred) {
                instanceVertex.property(Schema.VertexProperty.IS_INFERRED, true);
            }
        }
        Thing instance = (Thing)producer.apply(instanceVertex, (VertexElement)this.getThis());
        assert (instance != null) : "producer should never return null";
        return (V)instance;
    }

    private void preCheckForInstanceCreation() {
        this.vertex().tx().checkMutationAllowed();
        if (Schema.MetaSchema.isMetaLabel((Label)this.label())) {
            throw GraknTxOperationException.metaTypeImmutable((Label)this.label());
        }
    }

    public Stream<Role> playing() {
        Stream allRoles = this.directPlays().keySet().stream();
        Stream superSet = this.sups().filter(sup -> !sup.equals(this)).flatMap(sup -> TypeImpl.from(sup).directPlays().keySet().stream());
        return Stream.concat(allRoles, superSet);
    }

    public Stream<AttributeType> attributes() {
        Stream<AttributeType> attributes = this.attributes(Schema.ImplicitType.HAS_OWNER);
        return Stream.concat(attributes, this.keys());
    }

    public Stream<AttributeType> keys() {
        return this.attributes(Schema.ImplicitType.KEY_OWNER);
    }

    private Stream<AttributeType> attributes(Schema.ImplicitType implicitType) {
        String[] implicitIdentifiers = implicitType.getLabel("").getValue().split("--");
        String prefix = implicitIdentifiers[0] + "-";
        String suffix = "-" + implicitIdentifiers[1];
        return this.playing().map(role -> role.label().getValue()).filter(roleLabel -> roleLabel.startsWith(prefix) && roleLabel.endsWith(suffix)).map(roleLabel -> {
            String attributeTypeLabel = roleLabel.replace(prefix, "").replace(suffix, "");
            return this.vertex().tx().getAttributeType(attributeTypeLabel);
        });
    }

    public Map<Role, Boolean> directPlays() {
        return this.cachedDirectPlays.get();
    }

    @Override
    public void delete() {
        Map<Role, Boolean> plays = this.cachedDirectPlays.get();
        super.delete();
        plays.keySet().forEach(roleType -> ((RoleImpl)roleType).deleteCachedDirectPlaysByType((Type)this.getThis()));
    }

    @Override
    boolean deletionAllowed() {
        return super.deletionAllowed() && !this.currentShard().links().findAny().isPresent();
    }

    public Stream<V> instances() {
        return this.subs().flatMap(sub -> TypeImpl.from(sub).instancesDirect());
    }

    Stream<V> instancesDirect() {
        return this.vertex().getEdgesOfType(Direction.IN, Schema.EdgeLabel.SHARD).map(EdgeElement::source).map(source -> this.vertex().tx().factory().buildShard((VertexElement)source)).flatMap(Shard::links);
    }

    public Boolean isAbstract() {
        return this.cachedIsAbstract.get();
    }

    @Override
    void trackRolePlayers() {
        this.instances().forEach(concept -> ((ThingImpl)concept).castingsInstance().forEach(rolePlayer -> this.vertex().tx().txCache().trackForValidation((Casting)rolePlayer)));
    }

    public T play(Role role, boolean required) {
        this.checkSchemaMutationAllowed();
        this.cachedDirectPlays.ifPresent(map -> map.put(role, required));
        ((RoleImpl)role).addCachedDirectPlaysByType(this);
        EdgeElement edge = this.putEdge(ConceptVertex.from((Concept)role), Schema.EdgeLabel.PLAYS);
        if (required) {
            edge.property(Schema.EdgeProperty.REQUIRED, true);
        }
        return (T)((Type)this.getThis());
    }

    public T plays(Role role) {
        return this.play(role, false);
    }

    @Override
    boolean changingSuperAllowed(T oldSuperType, T newSuperType) {
        boolean changingSuperAllowed = super.changingSuperAllowed(oldSuperType, newSuperType);
        if (changingSuperAllowed && oldSuperType != null && !Schema.MetaSchema.isMetaLabel((Label)oldSuperType.label())) {
            Set superPlays = oldSuperType.playing().collect(Collectors.toSet());
            HashSet<Role> plays = new HashSet<Role>(this.directPlays().keySet());
            this.subs().flatMap(sub -> TypeImpl.from(sub).directPlays().keySet().stream()).forEach(plays::add);
            superPlays.removeAll(plays);
            if (!superPlays.isEmpty() && this.instancesDirect().findAny().isPresent()) {
                throw GraknTxOperationException.changingSuperWillDisconnectRole(oldSuperType, newSuperType, (Role)((Role)superPlays.iterator().next()));
            }
            return true;
        }
        return changingSuperAllowed;
    }

    public T unplay(Role role) {
        this.checkSchemaMutationAllowed();
        this.deleteEdge(Direction.OUT, Schema.EdgeLabel.PLAYS, new Concept[]{role});
        this.cachedDirectPlays.ifPresent(set -> {
            Boolean cfr_ignored_0 = (Boolean)set.remove(role);
        });
        ((RoleImpl)role).deleteCachedDirectPlaysByType(this);
        this.trackRolePlayers();
        return (T)((Type)this.getThis());
    }

    public T unhas(AttributeType attributeType) {
        return this.deleteAttribute(Schema.ImplicitType.HAS_OWNER, this.attributes(), attributeType);
    }

    public T unkey(AttributeType attributeType) {
        return this.deleteAttribute(Schema.ImplicitType.KEY_OWNER, this.keys(), attributeType);
    }

    private T deleteAttribute(Schema.ImplicitType implicitType, Stream<AttributeType> attributeTypes, AttributeType attributeToRemove) {
        if (attributeTypes.anyMatch(a -> a.equals(attributeToRemove))) {
            Label label = implicitType.getLabel(attributeToRemove.label());
            Role role = (Role)this.vertex().tx().getSchemaConcept(label);
            if (role != null) {
                this.unplay(role);
            }
        }
        return (T)((Type)this.getThis());
    }

    public T isAbstract(Boolean isAbstract) {
        if (!Schema.MetaSchema.isMetaLabel((Label)this.label()) && isAbstract.booleanValue() && this.instancesDirect().findAny().isPresent()) {
            throw GraknTxOperationException.addingInstancesToAbstractType((Type)this);
        }
        this.property(Schema.VertexProperty.IS_ABSTRACT, isAbstract);
        this.cachedIsAbstract.set(isAbstract);
        if (isAbstract.booleanValue()) {
            this.vertex().tx().txCache().removeFromValidation(this);
        } else {
            this.vertex().tx().txCache().trackForValidation(this);
        }
        return (T)((Type)this.getThis());
    }

    public T property(Schema.VertexProperty key, Object value) {
        if (!Schema.VertexProperty.CURRENT_LABEL_ID.equals((Object)key)) {
            this.checkSchemaMutationAllowed();
        }
        this.vertex().property(key, value);
        return (T)((Type)this.getThis());
    }

    private void updateAttributeRelationHierarchy(AttributeType attributeType, Schema.ImplicitType has, Schema.ImplicitType hasValue, Schema.ImplicitType hasOwner, Role ownerRole, Role valueRole, RelationshipType relationshipType) {
        AttributeType attributeTypeSuper = attributeType.sup();
        Label superLabel = attributeTypeSuper.label();
        Role ownerRoleSuper = this.vertex().tx().putRoleTypeImplicit(hasOwner.getLabel(superLabel));
        Role valueRoleSuper = this.vertex().tx().putRoleTypeImplicit(hasValue.getLabel(superLabel));
        RelationshipType relationshipTypeSuper = this.vertex().tx().putRelationTypeImplicit(has.getLabel(superLabel)).relates(ownerRoleSuper).relates(valueRoleSuper);
        ownerRole.sup(ownerRoleSuper);
        valueRole.sup(valueRoleSuper);
        relationshipType.sup(relationshipTypeSuper);
        if (!Schema.MetaSchema.ATTRIBUTE.getLabel().equals(superLabel)) {
            ((AttributeTypeImpl)attributeTypeSuper).plays(valueRoleSuper);
            this.updateAttributeRelationHierarchy(attributeTypeSuper, has, hasValue, hasOwner, ownerRoleSuper, valueRoleSuper, relationshipTypeSuper);
        }
    }

    private T has(AttributeType attributeType, Schema.ImplicitType has, Schema.ImplicitType hasValue, Schema.ImplicitType hasOwner, boolean required) {
        Label attributeLabel = attributeType.label();
        Role ownerRole = this.vertex().tx().putRoleTypeImplicit(hasOwner.getLabel(attributeLabel));
        Role valueRole = this.vertex().tx().putRoleTypeImplicit(hasValue.getLabel(attributeLabel));
        RelationshipType relationshipType = this.vertex().tx().putRelationTypeImplicit(has.getLabel(attributeLabel)).relates(ownerRole).relates(valueRole);
        this.play(ownerRole, required);
        ((AttributeTypeImpl)attributeType).play(valueRole, false);
        this.updateAttributeRelationHierarchy(attributeType, has, hasValue, hasOwner, ownerRole, valueRole, relationshipType);
        return (T)((Type)this.getThis());
    }

    public T has(AttributeType attributeType) {
        this.checkAttributeAttachmentLegal(Schema.ImplicitType.KEY_OWNER, attributeType);
        return this.has(attributeType, Schema.ImplicitType.HAS, Schema.ImplicitType.HAS_VALUE, Schema.ImplicitType.HAS_OWNER, false);
    }

    public T key(AttributeType attributeType) {
        this.checkAttributeAttachmentLegal(Schema.ImplicitType.HAS_OWNER, attributeType);
        return this.has(attributeType, Schema.ImplicitType.KEY, Schema.ImplicitType.KEY_VALUE, Schema.ImplicitType.KEY_OWNER, true);
    }

    private void checkAttributeAttachmentLegal(Schema.ImplicitType implicitType, AttributeType attributeType) {
        this.checkSchemaMutationAllowed();
        this.checkIfHasTargetMeta(attributeType);
        this.checkNonOverlapOfImplicitRelations(implicitType, attributeType);
    }

    private void checkIfHasTargetMeta(AttributeType attributeType) {
        if (Schema.MetaSchema.ATTRIBUTE.getLabel().equals(attributeType.label())) {
            throw GraknTxOperationException.metaTypeImmutable((Label)attributeType.label());
        }
    }

    private void checkNonOverlapOfImplicitRelations(Schema.ImplicitType implicitType, AttributeType attributeType) {
        if (this.attributes(implicitType).anyMatch(rt -> rt.equals(attributeType))) {
            throw GraknTxOperationException.duplicateHas((Type)this, (AttributeType)attributeType);
        }
    }

    public static <X extends Type, Y extends Thing> TypeImpl<X, Y> from(Type type) {
        return (TypeImpl)type;
    }
}

