/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.structure;

import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.PropertyNotUniqueException;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.kb.internal.structure.ElementId;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class AbstractElement<E extends Element, P extends Enum> {
    private final String prefix;
    private final E element;
    private final EmbeddedGraknTx tx;

    AbstractElement(EmbeddedGraknTx tx, E element, String prefix) {
        this.tx = tx;
        this.element = element;
        this.prefix = prefix;
    }

    public E element() {
        return this.element;
    }

    public ElementId id() {
        return ElementId.of(this.prefix + this.element().id());
    }

    public void delete() {
        this.element().remove();
    }

    public void property(P key, Object value) {
        if (value == null) {
            this.element().property(((Enum)key).name()).remove();
        } else {
            Property foundProperty = this.element().property(((Enum)key).name());
            if (!foundProperty.isPresent() || !foundProperty.value().equals(value)) {
                this.element().property(((Enum)key).name(), value);
            }
        }
    }

    @Nullable
    public <X> X property(P key) {
        Property property = this.element().property(((Enum)key).name());
        if (property != null && property.isPresent()) {
            return (X)property.value();
        }
        return null;
    }

    public Boolean propertyBoolean(P key) {
        Boolean value = (Boolean)this.property(key);
        if (value == null) {
            return false;
        }
        return value;
    }

    public EmbeddedGraknTx<?> tx() {
        return this.tx;
    }

    public int hashCode() {
        return T.id.hashCode();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof AbstractElement && ((AbstractElement)object).id().equals(this.id());
    }

    public void propertyUnique(P key, String value) {
        Vertex vertex;
        GraphTraversal traversal;
        if (!this.tx().isBatchTx() && (traversal = this.tx().getTinkerTraversal().V(new Object[0]).has(((Enum)key).name(), (Object)value)).hasNext() && (!(vertex = (Vertex)traversal.next()).equals(this.element()) || traversal.hasNext())) {
            if (traversal.hasNext()) {
                vertex = (Vertex)traversal.next();
            }
            throw PropertyNotUniqueException.cannotChangeProperty(this.element(), (Vertex)vertex, key, (Object)value);
        }
        this.property(key, value);
    }

    public <X> void propertyImmutable(P property, X newValue, @Nullable X foundValue, Function<X, Object> converter) {
        Objects.requireNonNull(property);
        if (foundValue != null) {
            if (!foundValue.equals(newValue)) {
                throw GraknTxOperationException.immutableProperty(foundValue, newValue, property);
            }
        } else {
            this.property(property, converter.apply(newValue));
        }
    }

    public <X> void propertyImmutable(P property, X newValue, X foundValue) {
        this.propertyImmutable(property, newValue, foundValue, Function.identity());
    }

    public String label() {
        return this.element().label();
    }

    public final boolean isDeleted() {
        return !this.tx().isValidElement((Element)this.element());
    }
}

