/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal.structure;

import ai.grakn.concept.LabelId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.kb.internal.cache.Cache;
import ai.grakn.kb.internal.cache.CacheOwner;
import ai.grakn.kb.internal.cache.Cacheable;
import ai.grakn.kb.internal.structure.EdgeElement;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class Casting
implements CacheOwner {
    private final Set<Cache> registeredCaches = new HashSet<Cache>();
    private final EdgeElement edgeElement;
    private final Cache<Role> cachedRole = Cache.createTxCache(this, Cacheable.concept(), () -> (Role)this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.ROLE_LABEL_ID)))));
    private final Cache<Thing> cachedInstance = Cache.createTxCache(this, Cacheable.concept(), () -> (Thing)this.edge().tx().factory().buildConcept(this.edge().target()));
    private final Cache<Relationship> cachedRelationship = Cache.createTxCache(this, Cacheable.concept(), () -> (Thing)this.edge().tx().factory().buildConcept(this.edge().source()));
    private final Cache<RelationshipType> cachedRelationshipType = Cache.createTxCache(this, Cacheable.concept(), () -> {
        if (this.cachedRelationship.isPresent()) {
            return this.cachedRelationship.get().type();
        }
        return (RelationshipType)this.edge().tx().getSchemaConcept(LabelId.of((Integer)((Integer)this.edge().property(Schema.EdgeProperty.RELATIONSHIP_TYPE_LABEL_ID))));
    });

    private Casting(EdgeElement edgeElement, @Nullable Relationship relationship, @Nullable Role role, @Nullable Thing thing) {
        this.edgeElement = edgeElement;
        if (relationship != null) {
            this.cachedRelationship.set(relationship);
        }
        if (role != null) {
            this.cachedRole.set(role);
        }
        if (thing != null) {
            this.cachedInstance.set(thing);
        }
    }

    public static Casting create(EdgeElement edgeElement, Relationship relationship, Role role, Thing thing) {
        return new Casting(edgeElement, relationship, role, thing);
    }

    public static Casting withThing(EdgeElement edgeElement, Thing thing) {
        return new Casting(edgeElement, null, null, thing);
    }

    public static Casting withRelationship(EdgeElement edgeElement, Relationship relationship) {
        return new Casting(edgeElement, relationship, null, null);
    }

    private EdgeElement edge() {
        return this.edgeElement;
    }

    @Override
    public Collection<Cache> caches() {
        return this.registeredCaches;
    }

    public Role getRole() {
        return this.cachedRole.get();
    }

    public RelationshipType getRelationshipType() {
        return this.cachedRelationshipType.get();
    }

    public Relationship getRelationship() {
        return this.cachedRelationship.get();
    }

    public Thing getRolePlayer() {
        return this.cachedInstance.get();
    }

    public int hashCode() {
        return this.edge().id().hashCode();
    }

    public void delete() {
        this.edge().delete();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Casting casting = (Casting)object;
        return this.edge().id().equals(casting.edge().id());
    }
}

