/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.factory.AbstractInternalFactory;
import ai.grakn.graph.internal.GraknOrientDBGraph;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientDBInternalFactory
extends AbstractInternalFactory<GraknOrientDBGraph, OrientGraph> {
    private final Logger LOG = LoggerFactory.getLogger(OrientDBInternalFactory.class);
    private final Map<String, OrientGraphFactory> openFactories = new HashMap<String, OrientGraphFactory>();
    private static final String KEY_TYPE = "keytype";
    private static final String UNIQUE = "type";
    private static final String SPECIAL_IN_MEMORY = "memory";

    public OrientDBInternalFactory(String keyspace, String engineUrl, String config) {
        super(keyspace, engineUrl, config);
    }

    boolean isClosed(OrientGraph innerGraph) {
        return innerGraph.isClosed();
    }

    GraknOrientDBGraph buildGraknGraphFromTinker(OrientGraph graph, boolean batchLoading) {
        String engineUrl = this.engineUrl;
        if (engineUrl.equals(SPECIAL_IN_MEMORY)) {
            engineUrl = null;
        }
        return new GraknOrientDBGraph(graph, this.keyspace, engineUrl, batchLoading);
    }

    OrientGraph buildTinkerPopGraph(boolean batchLoading) {
        this.LOG.warn(ErrorMessage.CONFIG_IGNORED.getMessage(new Object[]{"pathToConfig", this.config}));
        return this.configureGraph(this.keyspace, this.engineUrl);
    }

    private OrientGraph configureGraph(String name, String address) {
        boolean schemaDefinitionRequired = false;
        if ("in-memory".equals(address)) {
            address = SPECIAL_IN_MEMORY;
        }
        OrientGraphFactory factory = this.getFactory(name, address);
        OrientGraph graph = factory.getNoTx();
        for (Schema.BaseType baseType : Schema.BaseType.values()) {
            try {
                graph.database().browseClass("V_" + baseType);
            }
            catch (IllegalArgumentException e) {
                schemaDefinitionRequired = true;
                break;
            }
        }
        if (schemaDefinitionRequired) {
            graph = this.createGraphWithSchema(factory, graph);
        }
        return graph;
    }

    private OrientGraph createGraphWithSchema(OrientGraphFactory factory, OrientGraph graph) {
        for (Schema.BaseType baseType : Schema.BaseType.values()) {
            graph.createVertexClass(baseType.name());
        }
        for (Schema.BaseType baseType : Schema.EdgeLabel.values()) {
            graph.createEdgeClass(baseType.name());
        }
        graph = this.createIndicesVertex(graph);
        graph.commit();
        return factory.getNoTx();
    }

    private OrientGraph createIndicesVertex(OrientGraph graph) {
        ResourceBundle keys = ResourceBundle.getBundle("indices-vertices");
        Set<String> keyString = keys.keySet();
        for (String conceptProperty : keyString) {
            String[] configs = keys.getString(conceptProperty).split(",");
            BaseConfiguration indexConfig = new BaseConfiguration();
            OType otype = OType.STRING;
            switch (configs[0]) {
                case "Long": {
                    otype = OType.LONG;
                    break;
                }
                case "Double": {
                    otype = OType.DOUBLE;
                    break;
                }
                case "Boolean": {
                    otype = OType.BOOLEAN;
                }
            }
            indexConfig.setProperty(KEY_TYPE, (Object)otype);
            if (Boolean.valueOf(configs[1]).booleanValue()) {
                indexConfig.setProperty(UNIQUE, (Object)"UNIQUE");
            }
            for (Schema.BaseType baseType : Schema.BaseType.values()) {
                if (graph.getVertexIndexedKeys(baseType.name()).contains(conceptProperty)) continue;
                graph.createVertexIndex(conceptProperty, baseType.name(), (Configuration)indexConfig);
            }
        }
        return graph;
    }

    private OrientGraphFactory getFactory(String name, String address) {
        String key;
        if (SPECIAL_IN_MEMORY.equals(name)) {
            address = SPECIAL_IN_MEMORY;
        }
        if (!this.openFactories.containsKey(key = name + address)) {
            this.openFactories.put(key, new OrientGraphFactory(address + ":" + name));
        }
        return this.openFactories.get(key);
    }
}

