/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.generator;

import ai.grakn.concept.Type;
import ai.grakn.generator.AbstractSchemaConceptGenerator;
import com.google.common.base.Preconditions;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;

public abstract class AbstractTypeGenerator<T extends Type>
extends AbstractSchemaConceptGenerator<T> {
    private Optional<Boolean> includeAbstract = Optional.empty();

    AbstractTypeGenerator(Class<T> type) {
        super(type);
    }

    private boolean willIncludeAbstractTypes() {
        return this.includeAbstract.orElse(true);
    }

    final AbstractSchemaConceptGenerator<T> makeExcludeAbstractTypes() {
        this.includeAbstract = Optional.of(false);
        return this;
    }

    public final void configure(Abstract abstract_) {
        Preconditions.checkArgument((!this.includeAbstract.isPresent() || this.includeAbstract.get() != false ? 1 : 0) != 0, (Object)"Cannot specify parameter is both abstract and non-abstract");
        this.includeAbstract = Optional.of(true);
    }

    public final void configure(NonAbstract nonAbstract) {
        Preconditions.checkArgument((!this.includeAbstract.isPresent() || this.includeAbstract.get() == false ? 1 : 0) != 0, (Object)"Cannot specify parameter is both abstract and non-abstract");
        this.includeAbstract = Optional.of(false);
    }

    @Override
    protected final boolean filter(T schemaConcept) {
        return this.willIncludeAbstractTypes() || schemaConcept.isAbstract() == false;
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface NonAbstract {
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface Abstract {
    }
}

