/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.generator;

import ai.grakn.Grakn;
import ai.grakn.GraknSession;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.generator.AbstractGenerator;
import ai.grakn.generator.Labels;
import ai.grakn.generator.MetasyntacticStrings;
import ai.grakn.generator.ResourceValues;
import ai.grakn.util.StringUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pholser.junit.quickcheck.MinimalCounterexampleHook;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraknTxs
extends AbstractGenerator<GraknTx>
implements MinimalCounterexampleHook {
    private static GraknTx lastGeneratedGraph;
    private static StringBuilder txSummary;
    private GraknTx tx;
    private Boolean open = null;
    private final ImmutableList<Runnable> mutators = ImmutableList.of(() -> {
        Label label = this.typeLabel();
        EntityType superType = this.entityType();
        EntityType entityType = this.tx.putEntityType(label).sup(superType);
        this.summaryAssign(entityType, "tx", "putEntityType", label);
        this.summary(entityType, "superType", superType);
    }, () -> {
        Label label = this.typeLabel();
        AttributeType.DataType dataType = this.gen(AttributeType.DataType.class);
        AttributeType superType = this.resourceType();
        AttributeType attributeType = this.tx.putAttributeType(label, dataType).sup(superType);
        this.summaryAssign(attributeType, "tx", "putResourceType", label, dataType);
        this.summary(attributeType, "superType", superType);
    }, () -> {
        Label label = this.typeLabel();
        Role superType = this.role();
        Role role = this.tx.putRole(label).sup(superType);
        this.summaryAssign(role, "tx", "putRole", label);
        this.summary(role, "superType", superType);
    }, () -> {
        Label label = this.typeLabel();
        RelationshipType superType = this.relationType();
        RelationshipType relationshipType = this.tx.putRelationshipType(label).sup(superType);
        this.summaryAssign(relationshipType, "tx", "putRelationshipType", label);
        this.summary(relationshipType, "superType", superType);
    }, () -> {
        Type type = this.type();
        Role role = this.role();
        type.plays(role);
        this.summary(type, "plays", role);
    }, () -> {
        Type type = this.type();
        AttributeType attributeType = this.resourceType();
        type.attribute(attributeType);
        this.summary(type, "resource", attributeType);
    }, () -> {
        Type type = this.type();
        AttributeType attributeType = this.resourceType();
        type.key(attributeType);
        this.summary(type, "key", attributeType);
    }, () -> {
        Type type = this.type();
        boolean isAbstract = this.random.nextBoolean();
        type.setAbstract(Boolean.valueOf(isAbstract));
        this.summary(type, "setAbstract", isAbstract);
    }, () -> {
        EntityType entityType1 = this.entityType();
        EntityType entityType2 = this.entityType();
        entityType1.sup(entityType2);
        this.summary(entityType1, "superType", entityType2);
    }, () -> {
        EntityType entityType = this.entityType();
        Entity entity = entityType.addEntity();
        this.summaryAssign(entity, entityType, "addEntity", new Object[0]);
    }, () -> {
        Role role1 = this.role();
        Role role2 = this.role();
        role1.sup(role2);
        this.summary(role1, "superType", role2);
    }, () -> {
        RelationshipType relationshipType1 = this.relationType();
        RelationshipType relationshipType2 = this.relationType();
        relationshipType1.sup(relationshipType2);
        this.summary(relationshipType1, "superType", relationshipType2);
    }, (Object[])new Runnable[]{() -> {
        RelationshipType relationshipType = this.relationType();
        Relationship relationship = relationshipType.addRelationship();
        this.summaryAssign(relationship, relationshipType, "addRelationship", new Object[0]);
    }, () -> {
        RelationshipType relationshipType = this.relationType();
        Role role = this.role();
        relationshipType.relates(role);
        this.summary(relationshipType, "relates", role);
    }, () -> {
        AttributeType attributeType1 = this.resourceType();
        AttributeType attributeType2 = this.resourceType();
        attributeType1.sup(attributeType2);
        this.summary(attributeType1, "superType", attributeType2);
    }, () -> {
        AttributeType attributeType = this.resourceType();
        Object value = ((ResourceValues)this.gen().make(ResourceValues.class, new Generator[0])).generate(this.random, this.status);
        Attribute attribute = attributeType.putAttribute(value);
        this.summaryAssign(attribute, attributeType, "putResource", StringUtil.valueToString(value));
    }, () -> {
        Rule rule1 = this.ruleType();
        Rule rule2 = this.ruleType();
        rule1.sup(rule2);
        this.summary(rule1, "superType", rule2);
    }, () -> {
        Thing thing = this.instance();
        Attribute attribute = this.resource();
        thing.attribute(attribute);
        this.summary(thing, "resource", attribute);
    }, () -> {
        Relationship relationship = this.relation();
        Role role = this.role();
        Thing thing = this.instance();
        relationship.addRolePlayer(role, thing);
        this.summary(relationship, "addRolePlayer", role, thing);
    }});

    public GraknTxs() {
        super(GraknTx.class);
    }

    public static GraknTx lastGeneratedGraph() {
        return lastGeneratedGraph;
    }

    private void mutateOnce() {
        boolean succesfulMutation = false;
        while (!succesfulMutation) {
            succesfulMutation = true;
            try {
                ((Runnable)this.random.choose(this.mutators)).run();
            }
            catch (GraknTxOperationException | KBGeneratorException | UnsupportedOperationException e) {
                succesfulMutation = false;
            }
        }
    }

    @Override
    public GraknTx generate() {
        boolean shouldOpen;
        String keyspace = (String)((MetasyntacticStrings)this.gen().make(MetasyntacticStrings.class, new Generator[0])).generate(this.random, this.status);
        GraknSession factory = Grakn.session((String)"in-memory", (String)keyspace);
        int size = this.status.size();
        GraknTxs.startSummary();
        txSummary.append("size: ").append(size).append("\n");
        this.closeGraph(lastGeneratedGraph);
        this.tx = factory.open(GraknTxType.WRITE);
        this.tx.admin().delete();
        this.tx = factory.open(GraknTxType.WRITE);
        for (int i = 0; i < size; ++i) {
            this.mutateOnce();
        }
        boolean bl = shouldOpen = this.open != null ? this.open.booleanValue() : this.random.nextBoolean();
        if (!shouldOpen) {
            this.tx.close();
        }
        GraknTxs.setLastGeneratedGraph(this.tx);
        return this.tx;
    }

    private static void setLastGeneratedGraph(GraknTx graph) {
        lastGeneratedGraph = graph;
    }

    private void closeGraph(GraknTx graph) {
        if (graph != null && !graph.isClosed()) {
            graph.close();
        }
    }

    public void configure(Open open) {
        this.setOpen(open.value());
    }

    public GraknTxs setOpen(boolean open) {
        this.open = open;
        return this;
    }

    private static void startSummary() {
        txSummary = new StringBuilder();
    }

    private void summary(Object target, String methodName, Object ... args) {
        txSummary.append(this.summaryFormat(target)).append(".").append(methodName).append("(");
        txSummary.append(Stream.of(args).map(this::summaryFormat).collect(Collectors.joining(", ")));
        txSummary.append(");\n");
    }

    private void summaryAssign(Object assign, Object target, String methodName, Object ... args) {
        this.summary(this.summaryFormat(assign) + " = " + this.summaryFormat(target), methodName, args);
    }

    private String summaryFormat(Object object) {
        if (object instanceof SchemaConcept) {
            return ((SchemaConcept)object).getLabel().getValue().replaceAll("-", "_");
        }
        if (object instanceof Thing) {
            Thing thing = (Thing)object;
            return this.summaryFormat(thing.type()) + thing.getId().getValue();
        }
        if (object instanceof Label) {
            return StringUtil.valueToString((Object)((Label)object).getValue());
        }
        return object.toString();
    }

    private Label typeLabel() {
        return (Label)((Labels)this.gen().make(Labels.class, new Generator[]{this.gen().make(MetasyntacticStrings.class, new Generator[0])})).generate(this.random, this.status);
    }

    private Type type() {
        Collection candidates = this.tx.admin().getMetaConcept().subs().collect(Collectors.toSet());
        return (Type)this.random.choose(candidates);
    }

    private EntityType entityType() {
        return (EntityType)this.random.choose((Collection)this.tx.admin().getMetaEntityType().subs().collect(Collectors.toSet()));
    }

    private Role role() {
        return (Role)this.random.choose((Collection)this.tx.admin().getMetaRole().subs().collect(Collectors.toSet()));
    }

    private AttributeType resourceType() {
        return (AttributeType)this.random.choose((Collection)this.tx.admin().getMetaResourceType().subs().collect(Collectors.toSet()));
    }

    private RelationshipType relationType() {
        return (RelationshipType)this.random.choose((Collection)this.tx.admin().getMetaRelationType().subs().collect(Collectors.toSet()));
    }

    private Rule ruleType() {
        return (Rule)this.random.choose((Collection)this.tx.admin().getMetaRule().subs().collect(Collectors.toSet()));
    }

    private Thing instance() {
        return this.chooseOrThrow(GraknTxs.allInstancesFrom(this.tx));
    }

    private Relationship relation() {
        return (Relationship)this.chooseOrThrow(this.tx.admin().getMetaRelationType().instances());
    }

    private Attribute resource() {
        return (Attribute)this.chooseOrThrow(this.tx.admin().getMetaResourceType().instances());
    }

    private <T> T chooseOrThrow(Stream<? extends T> stream) {
        Set collection = stream.collect(Collectors.toSet());
        if (collection.isEmpty()) {
            throw new KBGeneratorException();
        }
        return (T)this.random.choose(collection);
    }

    public static List<Concept> allConceptsFrom(GraknTx graph) {
        ArrayList concepts = Lists.newArrayList(GraknTxs.allSchemaElementsFrom(graph));
        concepts.addAll(GraknTxs.allInstancesFrom(graph).collect(Collectors.toSet()));
        return concepts;
    }

    public static Collection<? extends SchemaConcept> allSchemaElementsFrom(GraknTx graph) {
        HashSet allSchemaConcepts = new HashSet();
        allSchemaConcepts.addAll(graph.admin().getMetaConcept().subs().collect(Collectors.toSet()));
        allSchemaConcepts.addAll(graph.admin().getMetaRole().subs().collect(Collectors.toSet()));
        allSchemaConcepts.addAll(graph.admin().getMetaRule().subs().collect(Collectors.toSet()));
        return allSchemaConcepts;
    }

    public static Stream<? extends Thing> allInstancesFrom(GraknTx graph) {
        return graph.admin().getMetaConcept().instances();
    }

    public void handle(Object[] counterexample, Runnable action) {
        System.err.println("Graph generated:\n" + txSummary);
    }

    private static class KBGeneratorException
    extends RuntimeException {
        private KBGeneratorException() {
        }
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface Open {
        public boolean value() default true;
    }
}

