/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.matcher;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.graql.Match;
import ai.grakn.graql.Streamable;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.kb.internal.structure.Shard;
import ai.grakn.matcher.MatchableConcept;
import ai.grakn.util.Schema;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;

public class GraknMatchers {
    public static final Matcher<MatchableConcept> concept = GraknMatchers.type(Schema.MetaSchema.THING.getLabel());
    public static final Matcher<MatchableConcept> entity = GraknMatchers.type(Schema.MetaSchema.ENTITY.getLabel());
    public static final Matcher<MatchableConcept> resource = GraknMatchers.type(Schema.MetaSchema.ATTRIBUTE.getLabel());
    public static final Matcher<MatchableConcept> rule = GraknMatchers.rule(Schema.MetaSchema.RULE.getLabel());

    public static Matcher<Streamable<? extends Answer>> results(Matcher<? extends Iterable<? extends Map<? extends Var, ? extends MatchableConcept>>> matcher) {
        return new PropertyMatcher<Streamable<? extends Answer>, Iterable<? extends Map<? extends Var, ? extends MatchableConcept>>>(matcher){

            @Override
            public String getName() {
                return "results";
            }

            @Override
            Iterable<? extends Map<Var, ? extends MatchableConcept>> transform(Streamable<? extends Answer> item) {
                return item.stream().map(m -> Maps.transformValues((Map)m.map(), MatchableConcept::of)).collect(Collectors.toList());
            }
        };
    }

    public static Matcher<Match> allVariables(Matcher<? extends Iterable<? extends MatchableConcept>> matcher) {
        return new PropertyMatcher<Match, Iterable<? extends MatchableConcept>>(matcher){

            @Override
            public String getName() {
                return "allVariables";
            }

            @Override
            Iterable<? extends MatchableConcept> transform(Match item) {
                return item.stream().flatMap(result -> result.values().stream()).map(MatchableConcept::of).collect(Collectors.toList());
            }
        };
    }

    public static Matcher<Streamable<? extends Answer>> variable(final Var var, Matcher<? extends Iterable<? extends MatchableConcept>> matcher) {
        return new PropertyMatcher<Streamable<? extends Answer>, Iterable<? extends MatchableConcept>>(matcher){

            @Override
            public String getName() {
                return "variable";
            }

            @Override
            Iterable<? extends MatchableConcept> transform(Streamable<? extends Answer> item) {
                return item.stream().map(answer -> MatchableConcept.of(answer.get(var))).collect(Collectors.toList());
            }
        };
    }

    public static Matcher<MatchableConcept> hasValue(Object expectedValue) {
        return new PropertyEqualsMatcher<MatchableConcept, Object>(expectedValue){

            @Override
            public String getName() {
                return "hasValue";
            }

            @Override
            public Object transform(MatchableConcept item) {
                return item.get().asAttribute().getValue();
            }
        };
    }

    public static Matcher<MatchableConcept> hasType(Matcher<MatchableConcept> matcher) {
        return new PropertyMatcher<MatchableConcept, Iterable<? super MatchableConcept>>(Matchers.hasItem(matcher)){

            @Override
            public String getName() {
                return "hasType";
            }

            @Override
            Iterable<? super MatchableConcept> transform(MatchableConcept item) {
                return GraknMatchers.getTypes(item.get().asThing()).stream().map(MatchableConcept::of).collect(Collectors.toSet());
            }
        };
    }

    public static Matcher<MatchableConcept> isShard() {
        return new TypeSafeMatcher<MatchableConcept>(){

            public boolean matchesSafely(MatchableConcept concept) {
                return concept.get() instanceof Shard;
            }

            public void describeTo(Description description) {
                description.appendText("isShard()");
            }
        };
    }

    public static Matcher<MatchableConcept> isInstance() {
        return new TypeSafeMatcher<MatchableConcept>(){

            public boolean matchesSafely(MatchableConcept concept) {
                return concept.get().isThing();
            }

            public void describeTo(Description description) {
                description.appendText("isInstance()");
            }
        };
    }

    public static Matcher<MatchableConcept> type(String type) {
        return GraknMatchers.type(Label.of((String)type));
    }

    public static Matcher<MatchableConcept> type(Label expectedLabel) {
        return new PropertyEqualsMatcher<MatchableConcept, Label>(expectedLabel){

            @Override
            public String getName() {
                return "type";
            }

            @Override
            Label transform(MatchableConcept item) {
                Concept concept = item.get();
                return concept.isType() ? concept.asType().getLabel() : null;
            }
        };
    }

    public static Matcher<MatchableConcept> role(String type) {
        return GraknMatchers.role(Label.of((String)type));
    }

    public static Matcher<MatchableConcept> role(Label expectedLabel) {
        return new PropertyEqualsMatcher<MatchableConcept, Label>(expectedLabel){

            @Override
            public String getName() {
                return "role";
            }

            @Override
            Label transform(MatchableConcept item) {
                Concept concept = item.get();
                return concept.isRole() ? concept.asRole().getLabel() : null;
            }
        };
    }

    public static Matcher<MatchableConcept> rule(String type) {
        return GraknMatchers.rule(Label.of((String)type));
    }

    public static Matcher<MatchableConcept> rule(Label expectedLabel) {
        return new PropertyEqualsMatcher<MatchableConcept, Label>(expectedLabel){

            @Override
            public String getName() {
                return "rule";
            }

            @Override
            Label transform(MatchableConcept item) {
                Concept concept = item.get();
                return concept.isRule() ? concept.asRule().getLabel() : null;
            }
        };
    }

    public static Matcher<MatchableConcept> instance(Object value) {
        return GraknMatchers.instance(GraknMatchers.hasValue(value));
    }

    private static Matcher<MatchableConcept> instance(final Matcher<MatchableConcept> matcher) {
        return new PropertyMatcher<MatchableConcept, Iterable<? super MatchableConcept>>(Matchers.hasItem(matcher)){

            @Override
            public String getName() {
                return "instance";
            }

            @Override
            Iterable<? super MatchableConcept> transform(MatchableConcept item) {
                return item.get().asThing().attributes(new AttributeType[0]).filter(resource -> MatchableConcept.NAME_TYPES.contains((Object)resource.type().getLabel())).map(MatchableConcept::of).collect(Collectors.toSet());
            }

            @Override
            public Matcher<?> innerMatcher() {
                return matcher;
            }
        };
    }

    private static Set<Type> getTypes(Thing thing) {
        HashSet types = Sets.newHashSet();
        for (Type type = thing.type(); type != null; type = type.sup()) {
            types.add(type);
        }
        return types;
    }

    private static abstract class PropertyMatcher<T, S>
    extends TypeSafeDiagnosingMatcher<T> {
        private final Matcher<? extends S> matcher;

        PropertyMatcher(Matcher<? extends S> matcher) {
            this.matcher = matcher;
        }

        protected final boolean matchesSafely(T item, Description mismatch) {
            S transformed = this.transform(item);
            if (this.matcher.matches(transformed)) {
                return true;
            }
            mismatch.appendText(this.getName()).appendText("(");
            this.matcher.describeMismatch(transformed, mismatch);
            mismatch.appendText(")");
            return false;
        }

        public final void describeTo(Description description) {
            description.appendText(this.getName()).appendText("(").appendDescriptionOf(this.innerMatcher()).appendText(")");
        }

        public abstract String getName();

        public Matcher<?> innerMatcher() {
            return this.matcher;
        }

        abstract S transform(T var1);
    }

    private static abstract class PropertyEqualsMatcher<T, S>
    extends PropertyMatcher<T, S> {
        PropertyEqualsMatcher(S expected) {
            super(Matchers.is(expected));
        }
    }
}

