/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test;

import ai.grakn.GraknSystemProperty;
import ai.grakn.GraknTx;
import ai.grakn.test.GraknTestSetup;
import ai.grakn.util.SampleKBLoader;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SampleKBContext
extends SampleKBLoader
implements TestRule {
    private boolean assumption = true;

    private SampleKBContext(@Nullable Consumer<GraknTx> preLoad) {
        super(preLoad);
    }

    public static SampleKBContext empty() {
        return SampleKBContext.getContext(null);
    }

    public static SampleKBContext preLoad(Consumer<GraknTx> build) {
        return SampleKBContext.getContext(build);
    }

    public static SampleKBContext preLoad(String ... files) {
        return SampleKBContext.getContext(graknGraph -> {
            for (String file : files) {
                SampleKBContext.loadFromFile(graknGraph, file);
            }
        });
    }

    private static SampleKBContext getContext(@Nullable Consumer<GraknTx> preLoad) {
        GraknTestSetup.startCassandraIfNeeded();
        return new SampleKBContext(preLoad);
    }

    public SampleKBContext assumeTrue(boolean bool) {
        this.assumption = bool;
        return this;
    }

    public static void loadFromFile(GraknTx graph, String file) {
        SampleKBLoader.loadFromFile((GraknTx)graph, (String)(GraknSystemProperty.PROJECT_RELATIVE_DIR.value() + "/grakn-test-tools/src/main/graql/" + file));
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Assume.assumeTrue((boolean)SampleKBContext.this.assumption);
                base.evaluate();
            }
        };
    }
}

