/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.test.SampleKBContext;
import ai.grakn.test.kbs.TestKB;
import com.google.common.math.IntMath;
import java.util.function.Consumer;

public abstract class AbstractPathKB
extends TestKB {
    private static final Label key = Label.of((String)"index");
    private final String gqlFile;
    private final int n;
    private final int m;

    protected AbstractPathKB(String gqlFile, int n, int m) {
        this.gqlFile = gqlFile;
        this.n = n;
        this.m = m;
    }

    protected void buildExtensionalDB(GraknTx tx, int n, int children) {
        int j;
        int m;
        int i;
        long startTime = System.currentTimeMillis();
        EntityType vertex = tx.getEntityType("vertex");
        EntityType startVertex = tx.getEntityType("start-vertex");
        Role arcFrom = tx.getRole("arc-from");
        Role arcTo = tx.getRole("arc-to");
        RelationshipType arc = tx.getRelationshipType("arc");
        AbstractPathKB.putEntity(tx, "a0", startVertex, key);
        for (i = 1; i <= n; ++i) {
            m = IntMath.pow((int)children, (int)i);
            for (j = 0; j < m; ++j) {
                AbstractPathKB.putEntity(tx, "a" + i + "," + j, vertex, key);
                if (j == 0 || j % 100 != 0) continue;
                System.out.println(j + " entities out of " + m + " inserted");
            }
        }
        for (int j2 = 0; j2 < children; ++j2) {
            arc.addRelationship().addRolePlayer(arcFrom, AbstractPathKB.getInstance(tx, "a0")).addRolePlayer(arcTo, AbstractPathKB.getInstance(tx, "a1," + j2));
        }
        for (i = 1; i < n; ++i) {
            m = IntMath.pow((int)children, (int)i);
            for (j = 0; j < m; ++j) {
                for (int c = 0; c < children; ++c) {
                    arc.addRelationship().addRolePlayer(arcFrom, AbstractPathKB.getInstance(tx, "a" + i + "," + j)).addRolePlayer(arcTo, AbstractPathKB.getInstance(tx, "a" + (i + 1) + "," + (j * children + c)));
                }
                if (j == 0 || j % 100 != 0) continue;
                System.out.println("level " + i + "/" + (n - 1) + ": " + j + " entities out of " + m + " connected");
            }
        }
        long loadTime = System.currentTimeMillis() - startTime;
        System.out.println("PathKB loading time: " + loadTime + " ms");
    }

    @Override
    public Consumer<GraknTx> build() {
        return tx -> {
            SampleKBContext.loadFromFile(tx, this.gqlFile);
            this.buildExtensionalDB((GraknTx)tx, this.n, this.m);
        };
    }
}

