/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.test.kbs;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.graql.Pattern;
import ai.grakn.test.kbs.TestKB;
import java.util.function.Consumer;

public class CWKB
extends TestKB {
    private static AttributeType<String> key;
    private static EntityType person;
    private static EntityType weapon;
    private static EntityType rocket;
    private static EntityType country;
    private static AttributeType<String> alignment;
    private static AttributeType<String> propulsion;
    private static AttributeType<String> nationality;
    private static RelationshipType isEnemyOf;
    private static RelationshipType isPaidBy;
    private static RelationshipType owns;
    private static Role enemySource;
    private static Role enemyTarget;
    private static Role owner;
    private static Role ownedItem;
    private static Role payee;
    private static Role payer;
    private static Role seller;
    private static Role buyer;
    private static Role transactionItem;
    private static Thing colonelWest;
    private static Thing Nono;
    private static Thing America;
    private static Thing Tomahawk;

    public static Consumer<GraknTx> get() {
        return new CWKB().build();
    }

    @Override
    protected void buildSchema(GraknTx tx) {
        key = tx.putAttributeType("name", AttributeType.DataType.STRING);
        nationality = tx.putAttributeType("nationality", AttributeType.DataType.STRING);
        propulsion = tx.putAttributeType("propulsion", AttributeType.DataType.STRING);
        alignment = tx.putAttributeType("alignment", AttributeType.DataType.STRING);
        owner = tx.putRole("item-owner");
        ownedItem = tx.putRole("owned-item");
        seller = tx.putRole("seller");
        buyer = tx.putRole("buyer");
        payee = tx.putRole("payee");
        payer = tx.putRole("payer");
        enemySource = tx.putRole("enemy-source");
        enemyTarget = tx.putRole("enemy-target");
        transactionItem = tx.putRole("transaction-item");
        person = tx.putEntityType("person").plays(seller).plays(payee).attribute(key).attribute(nationality);
        tx.putEntityType("criminal").plays(seller).plays(payee).attribute(key).attribute(nationality);
        weapon = tx.putEntityType("weapon").plays(transactionItem).plays(ownedItem).attribute(key);
        rocket = tx.putEntityType("rocket").plays(transactionItem).plays(ownedItem).attribute(key).attribute(propulsion);
        tx.putEntityType("missile").sup(weapon).plays(transactionItem).attribute(propulsion).attribute(key);
        country = tx.putEntityType("country").plays(buyer).plays(owner).plays(enemyTarget).plays(payer).plays(enemySource).attribute(key).attribute(alignment);
        owns = tx.putRelationshipType("owns").relates(owner).relates(ownedItem);
        isEnemyOf = tx.putRelationshipType("is-enemy-of").relates(enemySource).relates(enemyTarget);
        tx.putRelationshipType("transaction").relates(seller).relates(buyer).relates(transactionItem);
        isPaidBy = tx.putRelationshipType("is-paid-by").relates(payee).relates(payer);
    }

    @Override
    protected void buildInstances(GraknTx tx) {
        colonelWest = CWKB.putEntity(tx, "colonelWest", person, key.getLabel());
        Nono = CWKB.putEntity(tx, "Nono", country, key.getLabel());
        America = CWKB.putEntity(tx, "America", country, key.getLabel());
        Tomahawk = CWKB.putEntity(tx, "Tomahawk", rocket, key.getLabel());
        CWKB.putResource(colonelWest, nationality, "American");
        CWKB.putResource(Tomahawk, propulsion, "gsp");
    }

    @Override
    protected void buildRelations(GraknTx tx) {
        isEnemyOf.addRelationship().addRolePlayer(enemySource, Nono).addRolePlayer(enemyTarget, America);
        owns.addRelationship().addRolePlayer(owner, Nono).addRolePlayer(ownedItem, Tomahawk);
        isPaidBy.addRelationship().addRolePlayer(payee, colonelWest).addRolePlayer(payer, Nono);
    }

    @Override
    protected void buildRules(GraknTx tx) {
        Pattern R1_LHS = tx.graql().parsePattern("{$x isa person;$x has nationality 'American';$y isa weapon;$z isa country;$z has alignment 'hostile';(seller: $x, transaction-item: $y, buyer: $z) isa transaction;}");
        Pattern R1_RHS = tx.graql().parsePattern("{$x isa criminal;}");
        tx.putRule("R1: It is a crime for an American to sell weapons to hostile nations", R1_LHS, R1_RHS);
        Pattern R2_LHS = tx.graql().parsePattern("{$x isa missile;}");
        Pattern R2_RHS = tx.graql().parsePattern("{$x isa weapon;}");
        tx.putRule("R2: Missiles are a kind of a weapon\"", R2_LHS, R2_RHS);
        Pattern R3_LHS = tx.graql().parsePattern("{$x isa country;($x, $y) isa is-enemy-of;$y isa country;$y has name 'America';}");
        Pattern R3_RHS = tx.graql().parsePattern("{$x has alignment 'hostile';}");
        tx.putRule("R3: If a country is an enemy of America then it is hostile", R3_LHS, R3_RHS);
        Pattern R4_LHS = tx.graql().parsePattern("{$x isa rocket;$x has propulsion 'gsp';}");
        Pattern R4_RHS = tx.graql().parsePattern("{$x isa missile;}");
        tx.putRule("R4: If a rocket is self-propelled and guided, it is a missile", R4_LHS, R4_RHS);
        Pattern R5_LHS = tx.graql().parsePattern("{$x isa person;$y isa country;$z isa weapon;($x, $y) isa is-paid-by;($y, $z) isa owns;}");
        Pattern R5_RHS = tx.graql().parsePattern("{(seller: $x, buyer: $y, transaction-item: $z) isa transaction;}");
        tx.putRule("R5: If a country pays a person and that country now owns a weapon then the person has sold the country a weapon", R5_LHS, R5_RHS);
    }
}

